/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.pulsar.annotation;

import io.micronaut.context.annotation.AliasFor;
import io.micronaut.context.annotation.Aliases;
import io.micronaut.context.annotation.Executable;
import io.micronaut.messaging.annotation.MessageListener;
import io.micronaut.messaging.annotation.MessageMapping;
import io.micronaut.pulsar.MessageSchema;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.pulsar.client.api.RegexSubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.schema.KeyValueEncodingType;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@Executable
@MessageListener
public @interface PulsarConsumer {
    @Aliases(value={@AliasFor(member="topic"), @AliasFor(annotation=MessageMapping.class, member="value")})
    public String value() default "";

    @Aliases(value={@AliasFor(member="value"), @AliasFor(annotation=MessageMapping.class, member="value")})
    public String topic() default "";

    @AliasFor(annotation=MessageMapping.class, member="value")
    public String[] topics() default {};

    @AliasFor(annotation=MessageMapping.class, member="value")
    public String topicsPattern() default "";

    public MessageSchema schema() default MessageSchema.BYTES;

    public MessageSchema keySchema() default MessageSchema.BYTES;

    public KeyValueEncodingType keyEncoding() default KeyValueEncodingType.INLINE;

    public String consumerName() default "";

    public String subscription() default "";

    public SubscriptionType subscriptionType() default SubscriptionType.Exclusive;

    public RegexSubscriptionMode subscriptionTopicsMode() default RegexSubscriptionMode.AllTopics;

    public int patternAutoDiscoveryPeriod() default -1;

    public boolean subscribeAsync() default true;

    public String ackTimeout() default "";

    public int receiverQueueSize() default 1000;

    public int priorityLevel() default -1;

    public String deadLetterTopic() default "";

    public int maxRetriesBeforeDlq() default 16;
}

