/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.pulsar.annotation;

import io.micronaut.aop.Around;
import io.micronaut.aop.Introduction;
import io.micronaut.context.annotation.AliasFor;
import io.micronaut.context.annotation.Type;
import io.micronaut.pulsar.MessageSchema;
import io.micronaut.pulsar.intercept.PulsarProducerAdvice;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.HashingScheme;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.common.schema.KeyValueEncodingType;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@Around
@Introduction
@Type(value={PulsarProducerAdvice.class})
public @interface PulsarProducer {
    @AliasFor(member="topic")
    public String value() default "";

    public String producerName() default "";

    @AliasFor(member="value")
    public String topic() default "";

    public MessageSchema schema() default MessageSchema.BYTES;

    public MessageSchema keySchema() default MessageSchema.BYTES;

    public KeyValueEncodingType keyEncoding() default KeyValueEncodingType.INLINE;

    public CompressionType compressionType() default CompressionType.NONE;

    public MessageRoutingMode messageRoutingMode() default MessageRoutingMode.RoundRobinPartition;

    public boolean multiSchema() default true;

    public boolean autoUpdatePartition() default true;

    public boolean blockQueue() default false;

    public boolean batching() default true;

    public int batchingMaxMessages() default 1000;

    public int batchingMaxBytes() default 131072;

    public boolean chunking() default false;

    public String encryptionKey() default "";

    public long initialSequenceId() default -9223372036854775808L;

    public HashingScheme hashingScheme() default HashingScheme.JavaStringHash;

    public boolean sendBefore() default false;
}

