/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.pulsar.annotation;

import io.micronaut.aop.Around;
import io.micronaut.aop.Introduction;
import io.micronaut.context.annotation.AliasFor;
import io.micronaut.context.annotation.Aliases;
import io.micronaut.messaging.annotation.MessageMapping;
import io.micronaut.pulsar.MessageSchema;
import jakarta.validation.constraints.Min;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.common.schema.KeyValueEncodingType;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER, ElementType.FIELD, ElementType.METHOD})
@Around
@Introduction
public @interface PulsarReader {
    @Aliases(value={@AliasFor(member="topic"), @AliasFor(annotation=MessageMapping.class, member="value")})
    public String value() default "";

    @Aliases(value={@AliasFor(member="value"), @AliasFor(annotation=MessageMapping.class, member="value")})
    public String topic() default "";

    public String subscriptionName() default "";

    public MessageSchema schema() default MessageSchema.BYTES;

    public MessageSchema keySchema() default MessageSchema.BYTES;

    public KeyValueEncodingType keyEncoding() default KeyValueEncodingType.INLINE;

    public String readerName() default "";

    public boolean subscribeAsync() default true;

    public boolean startMessageLatest() default true;

    @Min(value=0L)
    public @Min(value=0L) int readTimeout() default 0;

    public TimeUnit timeoutUnit() default TimeUnit.SECONDS;
}

