/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.pulsar.config;

import io.micronaut.core.annotation.NonNull;
import java.util.Properties;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.impl.auth.AuthenticationDisabled;

public abstract class AbstractPulsarConfiguration<K, V> {
    public static final int DEFAULT_PULSAR_MESSAGING_PORT = 6650;
    public static final String PREFIX = "pulsar";
    public static final String DEFAULT_SERVER_HOST_ADDRESS = "localhost";
    public static final String DEFAULT_BOOTSTRAP_SERVER = "pulsar://localhost:6650";
    public static final Authentication DEFAULT_PULSAR_AUTHENTICATION = new AuthenticationDisabled();
    public static final String TOPIC_NAME_VALIDATOR = "((non-)?persistent://)?((\\w+(-|\\w+)*\\w)|(\\$\\{tenant\\}))/(\\w+(-|\\w+)*\\w)/(\\w+(-|\\w+)*\\w)";
    public static final String TOPIC_NAME_PATTERN_VALIDATOR = "((non-)?persistent://)?((\\w+(-|\\w+)*\\w)|(\\$\\{tenant\\}))\\/(\\w+(-?\\w+)?/).+";
    public static final String TENANT_NAME_VALIDATOR = "\\w+(-|\\w+)*\\w";
    private final Properties config;

    protected AbstractPulsarConfiguration(Properties config) {
        this.config = config;
    }

    @NonNull
    public Properties getConfig() {
        return this.config == null ? new Properties() : this.config;
    }
}

