/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.pulsar.config;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.util.StringUtils;
import io.micronaut.pulsar.annotation.PulsarServiceUrlProvider;
import io.micronaut.pulsar.config.AbstractPulsarConfiguration;
import io.micronaut.pulsar.config.PulsarClientConfiguration;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.ServiceUrlProvider;
import org.apache.pulsar.client.impl.auth.AuthenticationToken;
import org.apache.pulsar.client.impl.auth.oauth2.AuthenticationFactoryOAuth2;

@ConfigurationProperties(value="pulsar")
@Requirements(value={@Requires(value="pulsar"), @Requires(missingBeans={PulsarClientConfiguration.class})})
public final class DefaultPulsarClientConfiguration
extends AbstractPulsarConfiguration
implements PulsarClientConfiguration {
    private Integer ioThreads;
    private Integer listenerThreads;
    private String sslProvider;
    private String serviceUrl;
    private final ServiceUrlProvider serviceUrlProvider;
    private Authentication pulsarAuthentication;
    private URL oauthIssuerUrl;
    private URL oauthCredentialsUrl;
    private String oauthAudience;
    private Boolean useDeadLetterQueue;
    private int defaultMaxRetryDlq = 16;
    private String tlsTrustStorePath;
    private String tlsTrustStorePassword;
    private String tlsCertFilePath;
    private Boolean tlsVerifyHostname;
    private Boolean tlsAllowInsecureConnection;
    private Set<String> tlsCiphers;
    private Set<String> tlsProtocols;
    private String defaultTenant;

    protected DefaultPulsarClientConfiguration(Environment environment, @Nullable @PulsarServiceUrlProvider ServiceUrlProvider serviceUrlProvider) {
        super(DefaultPulsarClientConfiguration.resolveDefaultConfiguration(environment));
        this.serviceUrlProvider = serviceUrlProvider;
    }

    @Override
    public Optional<Integer> getIoThreads() {
        return Optional.ofNullable(this.ioThreads);
    }

    public void setIoThreads(Integer ioThreads) {
        this.ioThreads = ioThreads;
    }

    @Override
    public Optional<Integer> getListenerThreads() {
        return Optional.ofNullable(this.listenerThreads);
    }

    public void setListenerThreads(Integer listenerThreads) {
        this.listenerThreads = listenerThreads;
    }

    public void setAuthenticationJwt(@Nullable String authenticationJwt) {
        this.pulsarAuthentication = new AuthenticationToken(authenticationJwt);
    }

    @Override
    public Optional<String> getSslProvider() {
        return Optional.ofNullable(this.sslProvider);
    }

    public void setTlsTrustStorePath(String tlsTrustStorePath) {
        this.tlsTrustStorePath = tlsTrustStorePath;
    }

    @Override
    public Optional<String> getTlsTrustStorePath() {
        return Optional.ofNullable(this.tlsTrustStorePath);
    }

    public void setTlsTrustStorePassword(String tlsTrustStorePassword) {
        this.tlsTrustStorePassword = tlsTrustStorePassword;
    }

    @Override
    public Optional<String> getTlsTrustStorePassword() {
        return Optional.ofNullable(this.tlsTrustStorePassword);
    }

    public void setTlsCertFilePath(String tlsCertFilePath) {
        this.tlsCertFilePath = tlsCertFilePath;
    }

    @Override
    public Optional<String> getTlsCertFilePath() {
        return Optional.ofNullable(this.tlsCertFilePath);
    }

    public void setTlsVerifyHostname(Boolean tlsVerifyHostname) {
        this.tlsVerifyHostname = tlsVerifyHostname;
    }

    @Override
    public Optional<Boolean> getTlsVerifyHostname() {
        return Optional.ofNullable(this.tlsVerifyHostname);
    }

    public void setTlsAllowInsecureConnection(Boolean tlsAllowInsecureConnection) {
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
    }

    @Override
    public Optional<Boolean> getTlsAllowInsecureConnection() {
        return Optional.ofNullable(this.tlsAllowInsecureConnection);
    }

    public void setTlsCiphers(Set<String> tlsCiphers) {
        this.tlsCiphers = tlsCiphers;
    }

    @Override
    public Optional<Set<String>> getTlsCiphers() {
        return Optional.ofNullable(this.tlsCiphers);
    }

    public void setTlsProtocols(Set<String> tlsProtocols) {
        this.tlsProtocols = tlsProtocols;
    }

    @Override
    public Optional<Set<String>> getTlsProtocols() {
        return Optional.ofNullable(this.tlsProtocols);
    }

    public void setSslProvider(String sslProvider) {
        this.sslProvider = sslProvider;
    }

    @Override
    public String getServiceUrl() {
        return Optional.ofNullable(this.serviceUrl).orElse("pulsar://localhost:6650");
    }

    public void setServiceUrl(@Nullable String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    @Override
    public Optional<ServiceUrlProvider> getServiceUrlProvider() {
        return Optional.ofNullable(this.serviceUrlProvider);
    }

    @Override
    public Authentication getAuthentication() {
        return Optional.ofNullable(this.pulsarAuthentication).orElse(DEFAULT_PULSAR_AUTHENTICATION);
    }

    public Optional<String> getOauthAudience() {
        return Optional.ofNullable(this.oauthAudience);
    }

    public void setOauthAudience(String oauthAudience) {
        this.oauthAudience = oauthAudience;
        this.generateAuthenticationOAuth2();
    }

    public Optional<URL> getOauthCredentialsUrl() {
        return Optional.ofNullable(this.oauthCredentialsUrl);
    }

    public void setOauthCredentialsUrl(URL oauthCredentialsUrl) {
        this.oauthCredentialsUrl = oauthCredentialsUrl;
        this.generateAuthenticationOAuth2();
    }

    public URL getOauthIssuerUrl() {
        return this.oauthIssuerUrl;
    }

    public void setOauthIssuerUrl(URL oauthIssuerUrl) {
        this.oauthIssuerUrl = oauthIssuerUrl;
        this.generateAuthenticationOAuth2();
    }

    public Boolean getUseDeadLetterQueue() {
        return Optional.ofNullable(this.useDeadLetterQueue).orElse(true);
    }

    public void setUseDeadLetterQueue(Boolean useDeadLetterQueue) {
        this.useDeadLetterQueue = useDeadLetterQueue;
    }

    public int getDefaultMaxRetryDlq() {
        return this.defaultMaxRetryDlq;
    }

    public void setDefaultMaxRetryDlq(int defaultMaxRetryDlq) {
        if (defaultMaxRetryDlq < 1) {
            throw new IllegalArgumentException("Default number of max retries for DLQ must be greater than 0");
        }
        this.defaultMaxRetryDlq = defaultMaxRetryDlq;
    }

    private void generateAuthenticationOAuth2() {
        if (null == this.oauthIssuerUrl || null == this.oauthCredentialsUrl || StringUtils.isEmpty((CharSequence)this.oauthAudience)) {
            return;
        }
        this.pulsarAuthentication = AuthenticationFactoryOAuth2.clientCredentials((URL)this.oauthIssuerUrl, (URL)this.oauthCredentialsUrl, (String)this.oauthAudience);
    }

    private static Properties resolveDefaultConfiguration(Environment environment) {
        Map values = environment.containsProperties("pulsar") ? environment.getProperties("pulsar", StringConvention.RAW) : Collections.emptyMap();
        Properties properties = new Properties();
        values.forEach((key, value) -> {
            Optional converted;
            if (ConversionService.SHARED.canConvert(value.getClass(), String.class) && (converted = ConversionService.SHARED.convert(value, String.class)).isPresent()) {
                value = converted.get();
            }
            properties.setProperty((String)key, value.toString());
        });
        return properties;
    }

    @Override
    public Optional<String> getDefaultTenant() {
        return Optional.ofNullable(this.defaultTenant);
    }

    public void setDefaultTenant(String defaultTenant) {
        if (null != defaultTenant && !defaultTenant.matches("\\w+(-|\\w+)*\\w")) {
            throw new ConfigurationException(String.format("Default tenant value %s is not a valid tenant name for Apache Pulsar", defaultTenant));
        }
        this.defaultTenant = defaultTenant;
    }
}

