/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.pulsar.events;

import io.micronaut.pulsar.events.PulsarFailureEvent;
import java.util.Optional;

public final class ConsumerSubscriptionFailedEvent
implements PulsarFailureEvent {
    private final Throwable sourceError;
    private final String consumerName;
    private final String reason;

    public ConsumerSubscriptionFailedEvent(Throwable sourceError, String consumerName) {
        this.sourceError = sourceError;
        this.consumerName = consumerName;
        String error = "";
        if (null != sourceError) {
            error = sourceError.getMessage();
        }
        this.reason = String.format("Consumer %s failed to subscribe. %s", consumerName, error);
    }

    public Optional<Throwable> getSourceError() {
        return Optional.ofNullable(this.sourceError);
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    @Override
    public String getReason() {
        return this.reason;
    }
}

