/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.pulsar.events;

import io.micronaut.pulsar.events.PulsarFailureEvent;

public final class ProducerSubscriptionFailedEvent
implements PulsarFailureEvent {
    private final String producerName;
    private final String reason;
    private final Throwable sourceError;

    public ProducerSubscriptionFailedEvent(String producerName, Throwable sourceError) {
        this.producerName = producerName;
        this.sourceError = sourceError;
        String error = "";
        if (null != sourceError) {
            error = sourceError.getMessage();
        }
        this.reason = String.format("Producer %s failed to connect. %s", producerName, error);
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    public Throwable getSourceError() {
        return this.sourceError;
    }

    public String getProducerName() {
        return this.producerName;
    }
}

