/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.pulsar.processor;

import io.micronaut.inject.DelegatingExecutableMethod;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.pulsar.processor.ListenerKotlinHelper;
import io.micronaut.pulsar.processor.MessageListenerResolver;
import io.micronaut.pulsar.processor.PulsarArgumentHandler;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultListener
implements MessageListenerResolver {
    private final Logger LOGGER = LoggerFactory.getLogger(DefaultListener.class);
    private final ExecutableMethod<Object, ?> method;
    private final BiConsumer<Consumer<?>, Message<?>> receive;

    public DefaultListener(ExecutableMethod method, boolean useMessageWrapper, Object invoker, PulsarArgumentHandler argumentHandler) {
        this.method = method;
        boolean isSuspend = method instanceof DelegatingExecutableMethod ? ((DelegatingExecutableMethod)method).getTarget().isSuspend() : method.isSuspend();
        Map<String, Integer> headersOrder = argumentHandler.headersOrder();
        Map<String, Integer> argsOrder = argumentHandler.argumentOrder();
        int totalArgs = argumentHandler.size();
        boolean hasHeadersAsMap = argumentHandler.hasHeadersMap();
        this.receive = (c, v) -> {
            Object[] params = new Object[totalArgs];
            Object object = params[((Integer)argsOrder.get((Object)"body")).intValue()] = useMessageWrapper ? v : v.getValue();
            if (argsOrder.containsKey("consumer")) {
                params[((Integer)argsOrder.get((Object)"consumer")).intValue()] = c;
            }
            if (argsOrder.containsKey("key")) {
                params[((Integer)argsOrder.get((Object)"key")).intValue()] = v.getKey();
            }
            if (hasHeadersAsMap) {
                params[((Integer)argsOrder.get((Object)"headers")).intValue()] = v.getProperties();
            } else {
                headersOrder.keySet().forEach(x -> {
                    params[((Integer)headersOrder.get((Object)x)).intValue()] = v.getProperties().get(x);
                });
            }
            if (isSuspend) {
                ListenerKotlinHelper.run(method, invoker, params);
            } else {
                method.invoke(invoker, params);
            }
        };
    }

    public void received(Consumer consumer, Message msg) {
        try {
            this.receive.accept(consumer, msg);
            consumer.acknowledgeAsync(msg);
        }
        catch (Exception ex) {
            consumer.negativeAcknowledge(msg.getMessageId());
            this.LOGGER.error("Could not parse message [{}] for [{}] on method [{}]", new Object[]{msg.getMessageId(), consumer.getConsumerName(), this.method.getName(), ex});
        }
    }
}

