/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.pulsar.processor;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.messaging.exceptions.MessageListenerException;
import io.micronaut.pulsar.MessageSchema;
import io.micronaut.pulsar.schemas.SchemaResolver;
import jakarta.inject.Singleton;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.schema.BooleanSchema;
import org.apache.pulsar.client.impl.schema.ByteBufferSchema;
import org.apache.pulsar.client.impl.schema.ByteSchema;
import org.apache.pulsar.client.impl.schema.BytesSchema;
import org.apache.pulsar.client.impl.schema.DateSchema;
import org.apache.pulsar.client.impl.schema.DoubleSchema;
import org.apache.pulsar.client.impl.schema.FloatSchema;
import org.apache.pulsar.client.impl.schema.IntSchema;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaImpl;
import org.apache.pulsar.client.impl.schema.LongSchema;
import org.apache.pulsar.client.impl.schema.ShortSchema;
import org.apache.pulsar.client.impl.schema.StringSchema;
import org.apache.pulsar.client.impl.schema.TimeSchema;
import org.apache.pulsar.client.impl.schema.TimestampSchema;
import org.apache.pulsar.common.schema.KeyValueEncodingType;

@Singleton
public class DefaultSchemaHandler {
    private final BeanContext context;

    public DefaultSchemaHandler(BeanContext context) {
        this.context = context;
    }

    public Schema<?> decideSchema(Argument<?> body, @Nullable Argument<?> key, AnnotationValue<?> topicAnnotation, String target) {
        boolean isKeyValue = key != null;
        MessageSchema schema = (MessageSchema)((Object)topicAnnotation.getRequiredValue("schema", MessageSchema.class));
        if (!isKeyValue) {
            return this.resolve(schema, body, target);
        }
        KeyValueEncodingType type = (KeyValueEncodingType)topicAnnotation.getRequiredValue(KeyValueEncodingType.class);
        Schema<?> bodyType = this.resolve(schema, body, target);
        Schema<?> keyType = type == KeyValueEncodingType.INLINE ? this.resolve(schema, key, target) : this.resolve((MessageSchema)((Object)topicAnnotation.getRequiredValue("keySchema", MessageSchema.class)), key, target);
        return KeyValueSchemaImpl.of(bodyType, keyType, (KeyValueEncodingType)type);
    }

    private Schema<?> resolve(MessageSchema schema, Argument<?> argument, String target) {
        Schema<?> schema2;
        Class<?> type = DefaultSchemaHandler.bodyType(argument);
        if (MessageSchema.BYTES == schema && byte[].class != type) {
            if (String.class == type) {
                return StringSchema.utf8();
            }
            return ((SchemaResolver)this.context.getBean(SchemaResolver.class, Qualifiers.byName((String)MessageSchema.JSON.getSchemaResolverName()))).forArgument(type);
        }
        switch (schema) {
            case BYTES: {
                Schema<?> schema3;
                schema2 = schema3 = BytesSchema.of();
                break;
            }
            case BYTEBUFFER: {
                ByteBufferSchema byteBufferSchema = ByteBufferSchema.of();
                schema2 = byteBufferSchema;
                break;
            }
            case INT8: {
                ByteSchema byteSchema = ByteSchema.of();
                schema2 = byteSchema;
                break;
            }
            case INT16: {
                ShortSchema shortSchema = ShortSchema.of();
                schema2 = shortSchema;
                break;
            }
            case INT32: {
                IntSchema intSchema = IntSchema.of();
                schema2 = intSchema;
                break;
            }
            case INT64: {
                LongSchema longSchema = LongSchema.of();
                schema2 = longSchema;
                break;
            }
            case BOOL: {
                BooleanSchema booleanSchema = BooleanSchema.of();
                schema2 = booleanSchema;
                break;
            }
            case FLOAT: {
                FloatSchema floatSchema = FloatSchema.of();
                schema2 = floatSchema;
                break;
            }
            case DOUBLE: {
                DoubleSchema doubleSchema = DoubleSchema.of();
                schema2 = doubleSchema;
                break;
            }
            case DATE: {
                DateSchema dateSchema = DateSchema.of();
                schema2 = dateSchema;
                break;
            }
            case TIME: {
                TimeSchema timeSchema = TimeSchema.of();
                schema2 = timeSchema;
                break;
            }
            case TIMESTAMP: {
                TimestampSchema timestampSchema = TimestampSchema.of();
                schema2 = timestampSchema;
                break;
            }
            case STRING: {
                StringSchema stringSchema = StringSchema.utf8();
                schema2 = stringSchema;
                break;
            }
            default: {
                try {
                    Schema<?> schema4;
                    schema2 = schema4 = ((SchemaResolver)this.context.getBean(SchemaResolver.class, Qualifiers.byName((String)schema.getSchemaResolverName()))).forArgument(type);
                    break;
                }
                catch (MessageListenerException typeHandlingException) {
                    throw new MessageListenerException(typeHandlingException.getMessage() + " (parameter: " + target + ")");
                }
            }
        }
        return schema2;
    }

    public static Class<?> bodyType(Argument<?> body) {
        if (Message.class.isAssignableFrom(body.getType())) {
            return body.getTypeParameters()[0].getType();
        }
        return body.getType();
    }
}

