/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.pulsar.processor;

import io.micronaut.core.annotation.Internal;
import io.micronaut.messaging.exceptions.MessageListenerException;
import io.micronaut.pulsar.config.PulsarClientConfiguration;
import io.micronaut.pulsar.processor.TopicResolver;
import jakarta.inject.Singleton;

@Internal
@Singleton
final class DefaultTopicResolver
implements TopicResolver {
    private final String defaultTenant;

    DefaultTopicResolver(PulsarClientConfiguration pulsarClientConfiguration) {
        this.defaultTenant = pulsarClientConfiguration.getDefaultTenant().orElse(null);
    }

    @Override
    public String resolve(String topic) {
        if (TopicResolver.isDynamicTenantInTopic(topic)) {
            if (null == this.defaultTenant) {
                throw new MessageListenerException(String.format("Consumer specified dynamic tenant name in topic %s but no default tenant name set in the configuration", topic));
            }
            return TopicResolver.replaceTenantInTopic(topic, this.defaultTenant);
        }
        return topic;
    }
}

