/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.pulsar.processor;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.messaging.annotation.MessageBody;
import io.micronaut.messaging.annotation.MessageHeader;
import io.micronaut.pulsar.annotation.MessageKey;
import io.micronaut.pulsar.annotation.MessageProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;

@Internal
public final class PulsarArgumentHandler {
    private final LinkedHashMap<String, Argument<?>> methodArguments;
    private final Map<String, Integer> headers;

    public PulsarArgumentHandler(Argument<?>[] methodArguments, String methodPath) {
        this.methodArguments = PulsarArgumentHandler.processArguments(methodArguments, methodPath);
        this.headers = PulsarArgumentHandler.processSingleHeaders(methodArguments);
        if (this.hasHeaderList() && this.hasHeadersMap()) {
            throw new IllegalArgumentException("Cannot have both MessageProperties and individual mappings with MessageHeader on the same method.");
        }
    }

    private static Map<String, Integer> processSingleHeaders(Argument<?>[] arguments) {
        HashMap<String, Integer> headers = new HashMap<String, Integer>(arguments.length);
        for (int i = 0; i < arguments.length; ++i) {
            Argument<?> arg = arguments[i];
            Optional annotation = arg.findAnnotation(MessageHeader.class);
            if (!annotation.isPresent()) continue;
            String name = ((AnnotationValue)annotation.get()).stringValue().orElse(arg.getName());
            headers.put(name, i);
        }
        return Collections.unmodifiableMap(headers);
    }

    private static LinkedHashMap<String, Argument<?>> processArguments(Argument<?>[] arguments, String methodPath) {
        LinkedHashMap ordered = new LinkedHashMap(arguments.length);
        if (arguments.length == 1) {
            ordered.put("body", arguments[0]);
            return ordered;
        }
        for (Argument<?> nonHeaderArg : arguments) {
            if (nonHeaderArg.isAnnotationPresent(MessageBody.class)) {
                if (ordered.containsKey("body")) {
                    throw new IllegalArgumentException("Only 1 argument can be mapped as MessageBody on " + methodPath + ".");
                }
                ordered.put("body", nonHeaderArg);
                continue;
            }
            if (nonHeaderArg.isAnnotationPresent(MessageKey.class)) {
                if (ordered.containsKey("key")) {
                    throw new IllegalArgumentException("Only 1 argument can be mapped as MessageKey on " + methodPath + ".");
                }
                ordered.put("key", nonHeaderArg);
                continue;
            }
            if (nonHeaderArg.isAnnotationPresent(MessageProperties.class)) {
                if (ordered.containsKey("headers")) {
                    throw new IllegalArgumentException("Only 1 argument can be mapped as MessageProperties on " + methodPath + ".");
                }
                ordered.put(nonHeaderArg.getName(), nonHeaderArg);
                continue;
            }
            if (Consumer.class.isAssignableFrom(nonHeaderArg.getType())) {
                if (ordered.containsKey("consumer")) {
                    throw new IllegalArgumentException("Only 1 argument can be of type Consumer on " + methodPath + ".");
                }
                ordered.put("consumer", nonHeaderArg);
                continue;
            }
            if (nonHeaderArg.isAnnotationPresent(MessageHeader.class)) continue;
            throw new IllegalArgumentException("Argument must be annotated with MessageBody, MessageKey, or MessageProperties when more than 1 are present for " + methodPath);
        }
        if (ordered.containsKey("headers")) {
            Argument<?> map = ordered.get("headers");
            if (!Map.class.isAssignableFrom(map.getType())) {
                throw new IllegalArgumentException("Argument annotated with @MessageProperties must be a map");
            }
            if (!Arrays.stream(map.getTypeParameters()).allMatch(x -> String.class.isAssignableFrom(x.getType()))) {
                throw new IllegalArgumentException("MessageProperties map can only contain string keys and values");
            }
        }
        if (!ordered.containsKey("body")) {
            throw new IllegalArgumentException("Annotation io.micronaut.messaging.annotation.MessageBody must be present on a single parameter when more than 1 parameter is used with the consumer.");
        }
        return ordered;
    }

    public Argument<?> getBodyArgument() {
        return this.methodArguments.get("body");
    }

    public boolean isMessageWrapper() {
        return Message.class.isAssignableFrom(this.methodArguments.get("body").getType());
    }

    @Nullable
    public Argument<?> getKeyArgument() {
        return this.methodArguments.get("key");
    }

    public boolean hasHeaderList() {
        return !this.headers.isEmpty();
    }

    public boolean hasHeadersMap() {
        return this.methodArguments.containsKey("headers");
    }

    public Map<String, Integer> argumentOrder() {
        HashMap<String, Integer> order = new HashMap<String, Integer>(this.methodArguments.size());
        int i = 0;
        for (String key : this.methodArguments.keySet()) {
            order.put(key, i);
            ++i;
        }
        return Collections.unmodifiableMap(order);
    }

    public Map<String, Integer> headersOrder() {
        return this.headers;
    }

    public int size() {
        return this.argumentOrder().size() + this.headers.size();
    }
}

