/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.pulsar.processor;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.messaging.exceptions.MessageListenerException;
import io.micronaut.messaging.exceptions.MessagingException;
import java.util.Arrays;

@FunctionalInterface
public interface TopicResolver {
    public String resolve(String var1);

    default public String generateIdFromMessagingClientName(String name, TopicResolved topicResolved) {
        return name;
    }

    public static String replaceTenantInTopic(String topic, String tenant) {
        return topic.replaceFirst("\\$\\{(tenant)}", tenant);
    }

    public static boolean isDynamicTenantInTopic(String topic) {
        return topic.contains("${tenant}");
    }

    @NonNull
    public static TopicResolved extractTopic(AnnotationValue<?> pulsarAnnotation, String forName) {
        String topic = pulsarAnnotation.stringValue("topic", null).orElse(null);
        if (null != topic && !topic.isBlank()) {
            TopicResolver.verifyTopicValue(topic, forName);
            return new TopicResolved(topic, false);
        }
        Object[] topics = pulsarAnnotation.stringValues("topics", null);
        if (ArrayUtils.isNotEmpty((Object[])topics)) {
            Arrays.stream(topics).forEach(x -> TopicResolver.verifyTopicValue(x, forName));
            return new TopicResolved(topics, false);
        }
        String topicsPattern = pulsarAnnotation.stringValue("topicsPattern", null).orElse(null);
        if (null != topicsPattern && !topicsPattern.isBlank()) {
            if (topicsPattern.matches("((non-)?persistent://)?((\\w+(-|\\w+)*\\w)|(\\$\\{tenant\\}))\\/(\\w+(-?\\w+)?/).+")) {
                return new TopicResolved(topicsPattern, true);
            }
            throw new MessageListenerException("Consumer failed. Invalid topic pattern value %s. Must match %s".formatted(topicsPattern, "((non-)?persistent://)?((\\w+(-|\\w+)*\\w)|(\\$\\{tenant\\}))\\/(\\w+(-?\\w+)?/).+"));
        }
        throw new MessagingException("Missing topic value for %s".formatted(forName));
    }

    private static void verifyTopicValue(String topic, String forName) {
        if (null != topic && topic.matches("((non-)?persistent://)?((\\w+(-|\\w+)*\\w)|(\\$\\{tenant\\}))/(\\w+(-|\\w+)*\\w)/(\\w+(-|\\w+)*\\w)")) {
            return;
        }
        String message = "Invalid topic value %s for %s. Must match %s".formatted(topic, forName, "((non-)?persistent://)?((\\w+(-|\\w+)*\\w)|(\\$\\{tenant\\}))/(\\w+(-|\\w+)*\\w)/(\\w+(-|\\w+)*\\w)");
        throw new MessageListenerException(message);
    }

    public static final class TopicResolved {
        private final Object value;
        private final boolean isPattern;

        TopicResolved(Object value, boolean isPattern) {
            this.value = value;
            this.isPattern = isPattern;
        }

        public String getTopic() {
            if (this.isArray()) {
                throw new IllegalStateException("Resolving single topic when topic list was used");
            }
            return (String)this.value;
        }

        public String[] getTopics() {
            if (!this.isArray()) {
                throw new IllegalStateException("Resolving topic list when single topic was used");
            }
            return (String[])this.value;
        }

        public boolean isPattern() {
            return this.isPattern;
        }

        public boolean isArray() {
            return this.value instanceof String[];
        }

        public boolean isDynamicTenant() {
            if (this.isArray()) {
                return Arrays.stream(this.getTopics()).anyMatch(TopicResolver::isDynamicTenantInTopic);
            }
            return TopicResolver.isDynamicTenantInTopic(this.getTopic());
        }
    }
}

