/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.pulsar.schemas.json;

import io.micronaut.core.type.Argument;
import io.micronaut.json.JsonMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonReader<T>
implements SchemaReader<T> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonReader.class);
    private final Class<T> pojo;
    private final JsonMapper jsonMapper;

    public JsonReader(JsonMapper jsonMapper, Class<T> pojo) {
        this.pojo = pojo;
        this.jsonMapper = jsonMapper;
    }

    public T read(byte[] bytes, int offset, int length) {
        try {
            return (T)this.jsonMapper.readValue((InputStream)new ByteArrayInputStream(bytes, offset, length), Argument.of(this.pojo));
        }
        catch (IOException ex) {
            throw new SchemaSerializationException((Throwable)ex);
        }
    }

    public T read(InputStream inputStream) {
        Object value;
        try {
            value = this.jsonMapper.readValue(inputStream, Argument.of(this.pojo));
            try {
                inputStream.close();
            }
            catch (IOException closeException) {
                LOG.error("JsonReader close inputStream close error", (Throwable)closeException);
            }
        }
        catch (IOException ioException) {
            try {
                inputStream.close();
            }
            catch (IOException closeException) {
                LOG.error("JsonReader close inputStream close error", (Throwable)closeException);
            }
            throw new SchemaSerializationException((Throwable)ioException);
        }
        return (T)value;
    }
}

