/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.pulsar.schemas.json;

import io.micronaut.json.JsonMapper;
import io.micronaut.pulsar.schemas.json.JsonReader;
import io.micronaut.pulsar.schemas.json.JsonWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.api.schema.SchemaWriter;
import org.apache.pulsar.client.impl.schema.AvroBaseStructSchema;
import org.apache.pulsar.client.impl.schema.SchemaDefinitionBuilderImpl;
import org.apache.pulsar.client.impl.schema.util.SchemaUtil;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class JsonSchema<T>
extends AvroBaseStructSchema<T> {
    private static final Map<Integer, JsonSchema<?>> SCHEMAS = new ConcurrentHashMap(10);

    public JsonSchema(SchemaInfo schemaInfo, SchemaReader<T> reader, SchemaWriter<T> writer) {
        super(schemaInfo);
        this.setWriter(writer);
        this.setReader(reader);
    }

    public static <T> JsonSchema<T> of(Class<T> pojo, JsonMapper jsonMapper) {
        return SCHEMAS.computeIfAbsent(pojo.hashCode(), x -> {
            JsonReader reader = new JsonReader(jsonMapper, pojo);
            JsonWriter writer = new JsonWriter(jsonMapper);
            SchemaDefinition schemaDefinition = new SchemaDefinitionBuilderImpl().withPojo(pojo).withSchemaReader(reader).withSchemaWriter(writer).build();
            return new JsonSchema(SchemaUtil.parseSchemaInfo((SchemaDefinition)schemaDefinition, (SchemaType)SchemaType.JSON), reader, writer);
        });
    }
}

