/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.pulsar.schemas.json;

import io.micronaut.context.annotation.Requires;
import io.micronaut.json.JsonMapper;
import io.micronaut.pulsar.schemas.SchemaResolver;
import io.micronaut.pulsar.schemas.json.JsonSchema;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.apache.pulsar.client.api.Schema;

@Singleton
@Named(value="JSON_SCHEMA_RESOLVER")
@Requires(classes={JsonMapper.class})
public class JsonSchemaResolver
implements SchemaResolver {
    private final JsonMapper mapper;

    public JsonSchemaResolver(JsonMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public <T> Schema<T> forArgument(Class<T> pojo) {
        return JsonSchema.of(pojo, this.mapper);
    }
}

