/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.pulsar.schemas.protobuf;

import io.micronaut.core.type.Argument;
import io.micronaut.protobuf.codec.ProtobufferCodec;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.pulsar.client.api.schema.SchemaReader;

public class ProtobufReader<T>
implements SchemaReader<T> {
    private final ProtobufferCodec codec;
    private final Argument<T> type;

    public ProtobufReader(ProtobufferCodec codec, Argument<T> type) {
        this.codec = codec;
        this.type = type;
    }

    public T read(byte[] bytes, int offset, int length) {
        if (0 == offset && bytes.length == length) {
            return (T)this.codec.decode(this.type, bytes);
        }
        byte[] copy = Arrays.copyOfRange(bytes, offset, length);
        return (T)this.codec.decode(this.type, copy);
    }

    public T read(InputStream inputStream) {
        return (T)this.codec.decode(this.type, inputStream);
    }
}

