/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.pulsar.schemas.protobuf;

import io.micronaut.core.type.Argument;
import io.micronaut.protobuf.codec.ProtobufferCodec;
import io.micronaut.pulsar.schemas.protobuf.ProtobufReader;
import io.micronaut.pulsar.schemas.protobuf.ProtobufWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.impl.schema.AbstractStructSchema;
import org.apache.pulsar.client.impl.schema.SchemaDefinitionBuilderImpl;
import org.apache.pulsar.client.impl.schema.util.SchemaUtil;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public final class ProtobufSchema<T>
extends AbstractStructSchema<T> {
    private static final Map<Integer, ProtobufSchema<?>> SCHEMAS = new ConcurrentHashMap(10);

    public ProtobufSchema(SchemaInfo schemaInfo, ProtobufReader<T> reader, ProtobufWriter<T> writer) {
        super(schemaInfo);
        this.setReader(reader);
        this.setWriter(writer);
    }

    public static <T> ProtobufSchema<T> of(Class<T> type, ProtobufferCodec codec) {
        return SCHEMAS.computeIfAbsent(type.hashCode(), x -> {
            ProtobufWriter writer = new ProtobufWriter(codec);
            ProtobufReader reader = new ProtobufReader(codec, Argument.of((Class)type));
            SchemaDefinition schemaDefinition = new SchemaDefinitionBuilderImpl().withPojo(type).withSchemaWriter(writer).withSchemaReader(reader).build();
            return new ProtobufSchema(SchemaUtil.parseSchemaInfo((SchemaDefinition)schemaDefinition, (SchemaType)SchemaType.PROTOBUF), reader, writer);
        });
    }
}

