/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.pulsar.schemas.protobuf;

import com.google.protobuf.Message;
import io.micronaut.context.annotation.Requires;
import io.micronaut.messaging.exceptions.MessageListenerException;
import io.micronaut.protobuf.codec.ProtobufferCodec;
import io.micronaut.pulsar.schemas.SchemaResolver;
import io.micronaut.pulsar.schemas.protobuf.ProtobufSchema;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.apache.pulsar.client.api.Schema;

@Singleton
@Named(value="PROTOBUF_SCHEMA_RESOLVER")
@Requires(classes={ProtobufferCodec.class})
public class ProtobufSchemaResolver
implements SchemaResolver {
    private final ProtobufferCodec codec;

    public ProtobufSchemaResolver(ProtobufferCodec codec) {
        this.codec = codec;
    }

    @Override
    public <T> Schema<T> forArgument(Class<T> pojo) {
        if (!Message.class.isAssignableFrom(pojo)) {
            throw new MessageListenerException("Protocol buffers (native) are only supported for types that implement com.google.protobuf.Message");
        }
        return ProtobufSchema.of(pojo, this.codec);
    }
}

