/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.bind;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.messaging.Acknowledgement;
import io.micronaut.messaging.exceptions.MessageAcknowledgementException;
import io.micronaut.rabbitmq.bind.RabbitAcknowledgement;
import io.micronaut.rabbitmq.bind.RabbitConsumerState;
import io.micronaut.rabbitmq.bind.RabbitMessageCloseable;
import io.micronaut.rabbitmq.bind.RabbitTypeArgumentBinder;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class AcknowledgementBinder<T extends Acknowledgement>
implements RabbitTypeArgumentBinder<T> {
    public Argument<T> argumentType() {
        return Argument.of(Acknowledgement.class);
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, final RabbitConsumerState source) {
        RabbitAcknowledgement acknowledgement = new RabbitAcknowledgement(){

            @Override
            public void ack(boolean multiple) throws MessageAcknowledgementException {
                this.ackNack(true, multiple, false);
            }

            @Override
            public void nack(boolean multiple, boolean reQueue) throws MessageAcknowledgementException {
                this.ackNack(false, multiple, reQueue);
            }

            private void ackNack(boolean ack, boolean multiple, boolean requeue) throws MessageAcknowledgementException {
                new RabbitMessageCloseable(source, multiple, requeue).withAcknowledge(ack).close();
            }
        };
        return () -> Optional.of(acknowledgement);
    }
}

