/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.bind;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.ArgumentBinderRegistry;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.rabbitmq.bind.RabbitAnnotatedArgumentBinder;
import io.micronaut.rabbitmq.bind.RabbitArgumentBinder;
import io.micronaut.rabbitmq.bind.RabbitConsumerState;
import io.micronaut.rabbitmq.bind.RabbitDefaultBinder;
import io.micronaut.rabbitmq.bind.RabbitTypeArgumentBinder;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class RabbitBinderRegistry
implements ArgumentBinderRegistry<RabbitConsumerState> {
    private final Map<Class<? extends Annotation>, ArgumentBinder<?, RabbitConsumerState>> byAnnotation = new LinkedHashMap();
    private final Map<Integer, ArgumentBinder<?, RabbitConsumerState>> byType = new LinkedHashMap();
    private final RabbitDefaultBinder defaultBinder;

    public RabbitBinderRegistry(RabbitDefaultBinder defaultBinder, RabbitArgumentBinder ... binders) {
        this.defaultBinder = defaultBinder;
        if (ArrayUtils.isNotEmpty((Object[])binders)) {
            for (RabbitArgumentBinder binder : binders) {
                if (binder instanceof RabbitAnnotatedArgumentBinder) {
                    RabbitAnnotatedArgumentBinder annotatedBinder = (RabbitAnnotatedArgumentBinder)binder;
                    this.byAnnotation.put(annotatedBinder.getAnnotationType(), binder);
                    continue;
                }
                if (!(binder instanceof RabbitTypeArgumentBinder)) continue;
                RabbitTypeArgumentBinder typedBinder = (RabbitTypeArgumentBinder)binder;
                this.byType.put(typedBinder.argumentType().typeHashCode(), typedBinder);
            }
        }
    }

    public <T> Optional<ArgumentBinder<T, RabbitConsumerState>> findArgumentBinder(Argument<T> argument, RabbitConsumerState source) {
        Optional opt = argument.getAnnotationMetadata().getAnnotationTypeByStereotype(Bindable.class);
        if (opt.isPresent()) {
            Class annotationType = (Class)opt.get();
            ArgumentBinder<?, RabbitConsumerState> binder = this.byAnnotation.get(annotationType);
            if (binder != null) {
                return Optional.of(binder);
            }
        } else {
            ArgumentBinder<?, RabbitConsumerState> binder = this.byType.get(argument.typeHashCode());
            if (binder != null) {
                return Optional.of(binder);
            }
        }
        return Optional.of(this.defaultBinder);
    }
}

