/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.connect;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Connection;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.rabbitmq.connect.RabbitConnectionFactoryConfig;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import javax.inject.Singleton;

@Factory
public class RabbitConnectionFactory {
    @Bean(preDestroy="close")
    @Singleton
    @EachBean(value=RabbitConnectionFactoryConfig.class)
    Connection connection(RabbitConnectionFactoryConfig connectionFactory, BeanContext beanContext) {
        try {
            ExecutorService executorService = (ExecutorService)beanContext.getBean(ExecutorService.class, Qualifiers.byName((String)connectionFactory.getConsumerExecutor()));
            Optional<List<Address>> addresses = connectionFactory.getAddresses();
            if (addresses.isPresent()) {
                return connectionFactory.newConnection(executorService, addresses.get());
            }
            return connectionFactory.newConnection(executorService);
        }
        catch (IOException | TimeoutException e) {
            throw new BeanInstantiationException("Error creating connection to RabbitMQ", (Throwable)e);
        }
    }
}

