/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.intercept;

import com.rabbitmq.client.AMQP;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.caffeine.cache.Cache;
import io.micronaut.caffeine.cache.Caffeine;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.messaging.annotation.Body;
import io.micronaut.messaging.annotation.Header;
import io.micronaut.rabbitmq.annotation.Binding;
import io.micronaut.rabbitmq.annotation.RabbitClient;
import io.micronaut.rabbitmq.annotation.RabbitConnection;
import io.micronaut.rabbitmq.annotation.RabbitHeaders;
import io.micronaut.rabbitmq.annotation.RabbitProperty;
import io.micronaut.rabbitmq.bind.RabbitConsumerState;
import io.micronaut.rabbitmq.exception.RabbitClientException;
import io.micronaut.rabbitmq.intercept.MutableBasicProperties;
import io.micronaut.rabbitmq.intercept.StaticPublisherState;
import io.micronaut.rabbitmq.reactive.RabbitPublishState;
import io.micronaut.rabbitmq.reactive.ReactivePublisher;
import io.micronaut.rabbitmq.serdes.RabbitMessageSerDes;
import io.micronaut.rabbitmq.serdes.RabbitMessageSerDesRegistry;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.schedulers.Schedulers;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RabbitMQIntroductionAdvice
implements MethodInterceptor<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQIntroductionAdvice.class);
    private final BeanContext beanContext;
    private final ConversionService<?> conversionService;
    private final RabbitMessageSerDesRegistry serDesRegistry;
    private final Scheduler scheduler;
    private final Map<String, BiConsumer<Object, MutableBasicProperties>> properties = new HashMap<String, BiConsumer<Object, MutableBasicProperties>>();
    private final Cache<ExecutableMethod, StaticPublisherState> publisherCache = Caffeine.newBuilder().build();

    public RabbitMQIntroductionAdvice(BeanContext beanContext, ConversionService<?> conversionService, RabbitMessageSerDesRegistry serDesRegistry, @Named(value="io") ExecutorService executorService) {
        this.beanContext = beanContext;
        this.conversionService = conversionService;
        this.serDesRegistry = serDesRegistry;
        this.scheduler = Schedulers.from((Executor)executorService);
        this.properties.put("contentType", (prop, builder) -> this.convert("contentType", prop, String.class, builder::setContentType));
        this.properties.put("contentEncoding", (prop, builder) -> this.convert("contentEncoding", prop, String.class, builder::setContentEncoding));
        this.properties.put("deliveryMode", (prop, builder) -> this.convert("deliveryMode", prop, Integer.class, builder::setDeliveryMode));
        this.properties.put("priority", (prop, builder) -> this.convert("priority", prop, Integer.class, builder::setPriority));
        this.properties.put("correlationId", (prop, builder) -> this.convert("correlationId", prop, String.class, builder::setCorrelationId));
        this.properties.put("replyTo", (prop, builder) -> this.convert("replyTo", prop, String.class, builder::setReplyTo));
        this.properties.put("expiration", (prop, builder) -> this.convert("expiration", prop, String.class, builder::setExpiration));
        this.properties.put("messageId", (prop, builder) -> this.convert("messageId", prop, String.class, builder::setMessageId));
        this.properties.put("timestamp", (prop, builder) -> this.convert("timestamp", prop, Date.class, builder::setTimestamp));
        this.properties.put("type", (prop, builder) -> this.convert("type", prop, String.class, builder::setType));
        this.properties.put("userId", (prop, builder) -> this.convert("userId", prop, String.class, builder::setUserId));
        this.properties.put("appId", (prop, builder) -> this.convert("appId", prop, String.class, builder::setAppId));
        this.properties.put("clusterId", (prop, builder) -> this.convert("clusterId", prop, String.class, builder::setClusterId));
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        if (context.hasAnnotation(RabbitClient.class)) {
            Throwable throwable;
            StaticPublisherState publisherState = (StaticPublisherState)this.publisherCache.get((Object)context.getExecutableMethod(), method -> {
                ReactivePublisher reactivePublisher;
                AnnotationValue client = (AnnotationValue)method.findAnnotation(RabbitClient.class).orElseThrow(() -> new IllegalStateException("No @RabbitClient annotation present on method: " + method));
                String exchange = client.getValue(String.class).orElse("");
                Optional bindingAnn = method.findAnnotation(Binding.class);
                Optional routingKey = bindingAnn.flatMap(b -> b.getValue(String.class));
                String connection = method.findAnnotation(RabbitConnection.class).flatMap(conn -> conn.get((CharSequence)"connection", String.class)).orElse("default");
                Argument<?> bodyArgument = this.findBodyArgument((ExecutableMethod<?, ?>)method).orElseThrow(() -> new RabbitClientException("No valid message body argument found for method: " + method));
                HashMap<String, Object> methodHeaders = new HashMap<String, Object>();
                List headerAnnotations = method.getAnnotationValuesByType(Header.class);
                Collections.reverse(headerAnnotations);
                headerAnnotations.forEach(header -> {
                    String name = header.get((CharSequence)"name", String.class).orElse(null);
                    String value = header.getValue(String.class).orElse(null);
                    if (StringUtils.isNotEmpty((CharSequence)name) && StringUtils.isNotEmpty((CharSequence)value)) {
                        methodHeaders.put(name, value);
                    }
                });
                HashMap<String, String> methodProperties = new HashMap<String, String>();
                List propertyAnnotations = method.getAnnotationValuesByType(RabbitProperty.class);
                Collections.reverse(propertyAnnotations);
                propertyAnnotations.forEach(prop -> {
                    String name = prop.get((CharSequence)"name", String.class).orElse(null);
                    String value = prop.getValue(String.class).orElse(null);
                    if (StringUtils.isNotEmpty((CharSequence)name) && StringUtils.isNotEmpty((CharSequence)value)) {
                        if (this.properties.containsKey(name)) {
                            methodProperties.put(name, value);
                        } else {
                            throw new RabbitClientException(String.format("Attempted to set property [%s], but could not match the name to any of the com.rabbitmq.client.BasicProperties", name));
                        }
                    }
                });
                RabbitMessageSerDes<?> serDes = this.serDesRegistry.findSerdes(bodyArgument).orElseThrow(() -> new RabbitClientException(String.format("Could not find a serializer for the body argument of type [%s]", bodyArgument.getType().getName())));
                try {
                    reactivePublisher = (ReactivePublisher)this.beanContext.getBean(ReactivePublisher.class, Qualifiers.byName((String)connection));
                }
                catch (Throwable e) {
                    throw new RabbitClientException(String.format("Failed to retrieve a publisher named [%s] to publish messages", connection), e);
                }
                return new StaticPublisherState(exchange, routingKey.orElse(null), bodyArgument, methodHeaders, methodProperties, method.getReturnType(), serDes, reactivePublisher);
            });
            String exchange = publisherState.getExchange();
            String routingKey = publisherState.getRoutingKey().orElse(this.findRoutingKey(context).orElse(""));
            Argument bodyArgument = publisherState.getBodyArgument();
            MutableBasicProperties mutableProperties = new MutableBasicProperties();
            Map<String, Object> headers = publisherState.getHeaders();
            publisherState.getProperties().forEach((name, value) -> this.setBasicProperty(mutableProperties, (String)name, value));
            Argument[] arguments = context.getArguments();
            Map parameterValues = context.getParameterValueMap();
            for (Argument argument : arguments) {
                String argumentName;
                Object value2;
                String name2;
                Map.Entry<String, Object> entry;
                AnnotationValue headerAnn = argument.getAnnotation(Header.class);
                AnnotationValue propertyAnn = argument.getAnnotation(RabbitProperty.class);
                boolean headersMap = argument.getAnnotationMetadata().hasAnnotation(RabbitHeaders.class);
                if (headerAnn != null) {
                    entry = this.getNameAndValue(argument, headerAnn, parameterValues);
                    name2 = entry.getKey();
                    value2 = entry.getValue();
                    headers.put(name2, value2);
                    continue;
                }
                if (propertyAnn != null) {
                    entry = this.getNameAndValue(argument, propertyAnn, parameterValues);
                    name2 = entry.getKey();
                    value2 = entry.getValue();
                    this.setBasicProperty(mutableProperties, name2, value2);
                    continue;
                }
                if (headersMap) {
                    if (!argument.equalsType(Argument.mapOf(String.class, Object.class))) {
                        throw new RabbitClientException("The @RabbitHeaders annotation is applied to an argument that is not java.util.Map<String, ?>.");
                    }
                    Object value3 = parameterValues.get(argument.getName());
                    headers.putAll((Map)value3);
                    continue;
                }
                if (argument == bodyArgument || !this.properties.containsKey(argumentName = argument.getName())) continue;
                this.properties.get(argumentName).accept(parameterValues.get(argumentName), mutableProperties);
            }
            if (!headers.isEmpty()) {
                mutableProperties.setHeaders(headers);
            }
            ReturnType returnType = context.getReturnType();
            Class javaReturnType = returnType.getType();
            Object body = parameterValues.get(bodyArgument.getName());
            byte[] converted = publisherState.getSerDes().serialize(body, mutableProperties);
            AMQP.BasicProperties properties = mutableProperties.toBasicProperties();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending a message to exchange [{}] with binding [{}] and properties [{}]", new Object[]{exchange, routingKey, properties});
            }
            RabbitPublishState publishState = new RabbitPublishState(exchange, routingKey, properties, converted);
            Class dataTypeClass = publisherState.getDataType().getType();
            boolean isVoid = dataTypeClass == Void.TYPE || dataTypeClass == Void.class;
            boolean replyToSet = StringUtils.isNotEmpty((CharSequence)properties.getReplyTo());
            boolean rpc = replyToSet && !isVoid;
            ReactivePublisher reactivePublisher = publisherState.getReactivePublisher();
            if (publisherState.isReactive()) {
                Flowable reactive;
                if (rpc) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Publish is an RPC call. Publisher will complete when a response is received.", context);
                    }
                    reactive = Flowable.fromPublisher(reactivePublisher.publishAndReply(publishState)).flatMap(consumerState -> {
                        Object deserialized = this.deserialize((RabbitConsumerState)consumerState, (Argument)publisherState.getDataType(), (Argument)publisherState.getDataType());
                        if (deserialized == null) {
                            return Flowable.empty();
                        }
                        return Flowable.just((Object)deserialized);
                    }).subscribeOn(this.scheduler);
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Sending the message with publisher confirms.", context);
                    }
                    reactive = Flowable.fromPublisher(reactivePublisher.publishAndConfirm(publishState)).subscribeOn(this.scheduler);
                }
                return this.conversionService.convert((Object)reactive, javaReturnType).orElseThrow(() -> new RabbitClientException("Could not convert the publisher acknowledgement response to the return type of the method", Collections.singletonList(publishState)));
            }
            if (rpc) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Publish is an RPC call. Blocking until a response is received.", context);
                }
                return Single.fromPublisher(reactivePublisher.publishAndReply(publishState)).flatMapMaybe(consumerState -> {
                    Object deserialized = this.deserialize((RabbitConsumerState)consumerState, (Argument)publisherState.getDataType(), (Argument)publisherState.getDataType());
                    if (deserialized == null) {
                        return Maybe.empty();
                    }
                    return Maybe.just((Object)deserialized);
                }).blockingGet();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending the message without publisher confirms.", context);
            }
            if ((throwable = Completable.fromPublisher(reactivePublisher.publish(publishState)).blockingGet()) != null) {
                throw new RabbitClientException(String.format("Failed to publish a message with exchange: [%s] and routing key [%s]", exchange, routingKey), throwable, Collections.singletonList(publishState));
            }
            return null;
        }
        return context.proceed();
    }

    private Object deserialize(RabbitConsumerState consumerState, Argument dataType, Argument returnType) {
        Optional serDes = this.serDesRegistry.findSerdes(dataType);
        if (serDes.isPresent()) {
            return serDes.get().deserialize(consumerState, returnType);
        }
        throw new RabbitClientException(String.format("Could not find a deserializer for [%s]", dataType.getName()));
    }

    private Map.Entry<String, Object> getNameAndValue(Argument argument, AnnotationValue<?> annotationValue, Map<String, Object> parameterValues) {
        String argumentName = argument.getName();
        String name = annotationValue.get((CharSequence)"name", String.class).orElse(annotationValue.getValue(String.class).orElse(argumentName));
        Object value = parameterValues.get(argumentName);
        return new AbstractMap.SimpleEntry<String, Object>(name, value);
    }

    private void setBasicProperty(MutableBasicProperties mutableProperties, String name, Object value) {
        BiConsumer<Object, MutableBasicProperties> consumer = this.properties.get(name);
        if (consumer == null) {
            throw new RabbitClientException(String.format("Attempted to set property [%s], but could not match the name to any of the com.rabbitmq.client.BasicProperties", name));
        }
        consumer.accept(value, mutableProperties);
    }

    private <T> void convert(String name, Object value, Class<T> type, Consumer<? super T> consumer) {
        if (value == null) {
            consumer.accept(null);
        } else {
            consumer.accept(this.conversionService.convert(value, type).orElseThrow(() -> new RabbitClientException(String.format("Attempted to set property [%s], but could not convert the value to the required type [%s]", name, type.getName()))));
        }
    }

    private Optional<String> findRoutingKey(MethodInvocationContext<Object, Object> method) {
        Map argumentValues = method.getParameterValueMap();
        return Arrays.stream(method.getArguments()).filter(arg -> arg.getAnnotationMetadata().hasAnnotation(Binding.class)).map(Argument::getName).map(argumentValues::get).filter(Objects::nonNull).map(Object::toString).findFirst();
    }

    private Optional<Argument<?>> findBodyArgument(ExecutableMethod<?, ?> method) {
        return Optional.ofNullable(Arrays.stream(method.getArguments()).filter(arg -> arg.getAnnotationMetadata().hasAnnotation(Body.class)).findFirst().orElseGet(() -> Arrays.stream(method.getArguments()).filter(arg -> !arg.getAnnotationMetadata().hasStereotype(Bindable.class)).filter(arg -> !this.properties.containsKey(arg.getName())).findFirst().orElse(null)));
    }
}

