/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.metrics;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.MetricsCollector;
import com.rabbitmq.client.impl.MicrometerMetricsCollector;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.util.CollectionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
@RequiresMetrics
@Requires(property="micronaut.metrics.binders.rabbitmq.enabled", notEquals="false")
public class RabbitMetricsInterceptor
implements BeanCreatedEventListener<ConnectionFactory> {
    private final Provider<MeterRegistry> meterRegistryProvider;
    private final String prefix;
    private final List<Tag> tags;

    public RabbitMetricsInterceptor(Provider<MeterRegistry> meterRegistryProvider, @Nullable @Property(name="micronaut.metrics.binders.rabbitmq.prefix") String prefix, @Property(name="micronaut.metrics.binders.rabbitmq.tags") @MapFormat(transformation=MapFormat.MapTransformation.FLAT) Map<String, String> tags) {
        this.meterRegistryProvider = meterRegistryProvider;
        this.prefix = prefix == null ? "rabbitmq" : prefix;
        this.tags = CollectionUtils.isNotEmpty(tags) ? tags.entrySet().stream().map(entry -> Tag.of((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(Collectors.toList()) : Collections.emptyList();
    }

    public ConnectionFactory onCreated(BeanCreatedEvent<ConnectionFactory> event) {
        ConnectionFactory connectionFactory = (ConnectionFactory)event.getBean();
        connectionFactory.setMetricsCollector((MetricsCollector)new MicrometerMetricsCollector((MeterRegistry)this.meterRegistryProvider.get(), this.prefix, this.tags));
        return connectionFactory;
    }
}

