/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.connect;

import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.RecoveryDelayHandler;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.rabbitmq.connect.ChannelPool;
import io.micronaut.rabbitmq.connect.RabbitConnectionFactoryConfig;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EachBean(value=Connection.class)
public class DefaultChannelPool
implements AutoCloseable,
ChannelPool {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultChannelPool.class);
    private final LinkedBlockingQueue<Channel> channels;
    private final Connection connection;
    private final AtomicLong totalChannels = new AtomicLong(0L);
    private final String name;
    private final RecoveryDelayHandler recoveryDelayHandler;
    private final boolean topologyRecoveryEnabled;

    public DefaultChannelPool(@Parameter String name, @Parameter Connection connection, @Parameter RabbitConnectionFactoryConfig config) {
        this.name = name;
        this.connection = connection;
        Integer maxIdleChannels = config.getChannelPool().getMaxIdleChannels().orElse(null);
        this.recoveryDelayHandler = config.params(null).getRecoveryDelayHandler();
        this.topologyRecoveryEnabled = config.isTopologyRecoveryEnabled();
        this.channels = new LinkedBlockingQueue(maxIdleChannels == null ? Integer.MAX_VALUE : maxIdleChannels);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Channel getChannel() throws IOException {
        Channel channel = null;
        while (channel == null) {
            channel = this.channels.poll();
            if (channel == null) {
                channel = this.createChannel();
                continue;
            }
            if (channel.isOpen()) continue;
            channel = null;
            this.totalChannels.decrementAndGet();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieved channel [{}] from the pool", (Object)channel.toString());
        }
        return channel;
    }

    @Override
    public Channel getChannelWithRecoveringDelay(int recoveryAttempts) throws IOException, InterruptedException {
        Thread.sleep(this.recoveryDelayHandler.getDelay(recoveryAttempts));
        return this.getChannel();
    }

    @Override
    public boolean isTopologyRecoveryEnabled() {
        return this.topologyRecoveryEnabled;
    }

    @Override
    public void returnChannel(Channel channel) {
        if (channel.isOpen()) {
            if (this.channels.offer(channel)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Returned channel [{}] to the pool", (Object)channel.toString());
                }
            } else {
                this.closeChannel(channel);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Attempted to return a closed channel to the pool [{}]. Channel has been ignored", (Object)channel.toString());
            }
            this.totalChannels.decrementAndGet();
        }
    }

    protected Channel createChannel() throws IOException {
        Channel channel = this.connection.createChannel();
        this.totalChannels.incrementAndGet();
        return channel;
    }

    @Override
    @PreDestroy
    public void close() {
        if (this.totalChannels.get() > (long)this.channels.size() && LOG.isWarnEnabled()) {
            LOG.warn("Channel pool is being closed without all channels being returned! Any channels not returned are the responsibility of the owner to close. Total channels [{}] - Returned Channels [{}]", (Object)this.totalChannels.get(), (Object)this.channels.size());
        }
        Iterator<Channel> iterator = this.channels.iterator();
        while (iterator.hasNext()) {
            this.closeChannel(iterator.next());
            iterator.remove();
        }
    }

    private void closeChannel(Channel channel) {
        block4: {
            if (channel.isOpen()) {
                try {
                    channel.close();
                }
                catch (AlreadyClosedException alreadyClosedException) {
                }
                catch (IOException | TimeoutException e) {
                    if (!LOG.isWarnEnabled()) break block4;
                    LOG.warn(String.format("Failed to close the channel [%s]", channel.toString()), (Throwable)e);
                }
            }
        }
        this.totalChannels.decrementAndGet();
    }
}

