/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.serdes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.serialize.exceptions.SerializationException;
import io.micronaut.core.type.Argument;
import io.micronaut.rabbitmq.bind.RabbitConsumerState;
import io.micronaut.rabbitmq.intercept.MutableBasicProperties;
import io.micronaut.rabbitmq.serdes.RabbitMessageSerDes;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;

@Singleton
public class JsonRabbitMessageSerDes
implements RabbitMessageSerDes<Object> {
    public static final Integer ORDER = 200;
    private final ObjectMapper objectMapper;

    public JsonRabbitMessageSerDes(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public Object deserialize(RabbitConsumerState messageState, Argument<Object> type) {
        byte[] body = messageState.getBody();
        if (body == null || body.length == 0) {
            return null;
        }
        try {
            if (type.hasTypeVariables()) {
                JavaType javaType = this.constructJavaType(type);
                return this.objectMapper.readValue(body, javaType);
            }
            return this.objectMapper.readValue(body, type.getType());
        }
        catch (IOException e) {
            throw new SerializationException("Error decoding JSON stream for type [" + type.getName() + "]: " + e.getMessage());
        }
    }

    @Override
    public byte[] serialize(Object data, MutableBasicProperties basicProperties) {
        if (data == null) {
            return null;
        }
        try {
            byte[] serialized = this.objectMapper.writeValueAsBytes(data);
            if (serialized != null && basicProperties.getContentType() == null) {
                basicProperties.setContentType("application/json");
            }
            return serialized;
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("Error encoding object [" + data + "] to JSON: " + e.getMessage());
        }
    }

    public int getOrder() {
        return ORDER;
    }

    @Override
    public boolean supports(Argument<Object> argument) {
        return !ClassUtils.isJavaBasicType((Class)argument.getType());
    }

    private <T> JavaType constructJavaType(Argument<T> type) {
        Map typeVariables = type.getTypeVariables();
        TypeFactory typeFactory = this.objectMapper.getTypeFactory();
        JavaType[] objects = this.toJavaTypeArray(typeFactory, typeVariables);
        return typeFactory.constructParametricType(type.getType(), objects);
    }

    private JavaType[] toJavaTypeArray(TypeFactory typeFactory, Map<String, Argument<?>> typeVariables) {
        ArrayList<JavaType> javaTypes = new ArrayList<JavaType>();
        for (Argument<?> argument : typeVariables.values()) {
            if (argument.hasTypeVariables()) {
                javaTypes.add(typeFactory.constructParametricType(argument.getType(), this.toJavaTypeArray(typeFactory, argument.getTypeVariables())));
                continue;
            }
            javaTypes.add(typeFactory.constructType((Type)argument.getType()));
        }
        return javaTypes.toArray(new JavaType[0]);
    }
}

