/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.bind;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.messaging.annotation.MessageHeader;
import io.micronaut.rabbitmq.bind.RabbitAnnotatedArgumentBinder;
import io.micronaut.rabbitmq.bind.RabbitConsumerState;
import io.micronaut.rabbitmq.bind.RabbitHeaderConvertibleValues;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Optional;

@Singleton
public class RabbitHeaderBinder
implements RabbitAnnotatedArgumentBinder<MessageHeader> {
    private final ConversionService conversionService;

    public RabbitHeaderBinder(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Class<MessageHeader> getAnnotationType() {
        return MessageHeader.class;
    }

    public ArgumentBinder.BindingResult<Object> bind(ArgumentConversionContext<Object> context, RabbitConsumerState messageState) {
        String parameterName = context.getAnnotationMetadata().getValue(MessageHeader.class, String.class).orElse(context.getArgument().getName());
        Map rawHeaders = messageState.getProperties().getHeaders();
        RabbitHeaderConvertibleValues headers = new RabbitHeaderConvertibleValues(rawHeaders, this.conversionService);
        Optional<Object> header = headers.get(parameterName, context);
        return () -> header;
    }
}

