/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.bind;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class RabbitHeaderConvertibleValues
implements ConvertibleValues<Object> {
    private final Map<String, Object> headers;
    private final ConversionService<?> conversionService;
    private final List<ConversionError> conversionErrors = new ArrayList<ConversionError>();

    public RabbitHeaderConvertibleValues(Map<String, Object> headers, ConversionService<?> conversionService) {
        this.headers = headers == null ? Collections.emptyMap() : headers;
        this.conversionService = conversionService;
    }

    public Set<String> names() {
        return this.headers.keySet();
    }

    public Collection<Object> values() {
        return this.headers.values();
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        Object value = this.headers.get(name.toString());
        if (value != null) {
            Optional converted = this.conversionService.convert((Object)value.toString(), conversionContext);
            conversionContext.getLastError().ifPresent(this.conversionErrors::add);
            return converted;
        }
        return Optional.empty();
    }

    public List<ConversionError> getConversionErrors() {
        return this.conversionErrors;
    }
}

