/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.connect;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.ConnectionFactory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public abstract class RabbitConnectionFactoryConfig
extends ConnectionFactory {
    private static final String DEFAULT_CONSUMER_EXECUTOR = "consumer";
    private final String name;
    private RpcConfiguration rpc = new RpcConfiguration();
    private ChannelPoolConfiguration channelPool = new ChannelPoolConfiguration();
    private List<Address> addresses = null;
    private String consumerExecutor = "consumer";
    private Duration confirmTimeout = Duration.ofSeconds(5L);

    public RabbitConnectionFactoryConfig(@Parameter String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public RpcConfiguration getRpc() {
        return this.rpc;
    }

    public void setRpc(@NonNull RpcConfiguration rpc) {
        this.rpc = rpc;
    }

    public ChannelPoolConfiguration getChannelPool() {
        return this.channelPool;
    }

    public void setChannelPool(@NonNull ChannelPoolConfiguration channelPool) {
        this.channelPool = channelPool;
    }

    public Optional<List<Address>> getAddresses() {
        return Optional.ofNullable(this.addresses);
    }

    public void setAddresses(@Nullable List<Address> addresses) {
        this.addresses = addresses;
    }

    public String getConsumerExecutor() {
        return this.consumerExecutor;
    }

    public void setConsumerExecutor(@NonNull String consumerExecutor) {
        this.consumerExecutor = consumerExecutor;
    }

    public Duration getConfirmTimeout() {
        return this.confirmTimeout;
    }

    public void setConfirmTimeout(Duration confirmTimeout) {
        this.confirmTimeout = confirmTimeout;
    }

    public static class ChannelPoolConfiguration {
        private Integer maxIdleChannels = null;

        public Optional<Integer> getMaxIdleChannels() {
            return Optional.ofNullable(this.maxIdleChannels);
        }

        public void setMaxIdleChannels(@Nullable Integer maxIdleChannels) {
            this.maxIdleChannels = maxIdleChannels;
        }
    }

    public static class RpcConfiguration {
        public static final long DEFAULT_TIMEOUT_SECONDS = 10L;
        private Duration timeout = Duration.ofSeconds(10L);

        public Optional<Duration> getTimeout() {
            return Optional.ofNullable(this.timeout);
        }

        public void setTimeout(@Nullable Duration timeout) {
            this.timeout = timeout;
        }
    }
}

