/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.connect;

import com.rabbitmq.client.Channel;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.rabbitmq.connect.ChannelPool;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChannelInitializer
implements BeanCreatedEventListener<ChannelPool> {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelInitializer.class);

    public void initialize(Channel channel, String name) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelPool onCreated(BeanCreatedEvent<ChannelPool> event) {
        ChannelPool pool = (ChannelPool)event.getBean();
        Channel channel = null;
        try {
            channel = pool.getChannel();
            this.initialize(channel, pool.getName());
        }
        catch (Throwable e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Initialization of the channel has failed due to error", e);
            }
        }
        finally {
            if (channel != null) {
                pool.returnChannel(channel);
            }
        }
        return pool;
    }
}

