/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.connect;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Connection;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.rabbitmq.connect.RabbitConnectionFactoryConfig;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
public class RabbitConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitConnectionFactory.class);
    private final ConcurrentLinkedQueue<ActiveConnection> activeConnections = new ConcurrentLinkedQueue();

    @Singleton
    @EachBean(value=RabbitConnectionFactoryConfig.class)
    Connection connection(RabbitConnectionFactoryConfig connectionFactory, BeanContext beanContext) {
        try {
            ExecutorService executorService = (ExecutorService)beanContext.getBean(ExecutorService.class, Qualifiers.byName((String)connectionFactory.getConsumerExecutor()));
            Optional<List<Address>> addresses = connectionFactory.getAddresses();
            Connection connection = addresses.isPresent() ? connectionFactory.newConnection(executorService, addresses.get()) : connectionFactory.newConnection(executorService);
            this.activeConnections.add(new ActiveConnection(connection, connectionFactory));
            return connection;
        }
        catch (IOException | TimeoutException e) {
            throw new BeanInstantiationException("Error creating connection to RabbitMQ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    void shutdownConnections() {
        try {
            for (ActiveConnection activeConnection : this.activeConnections) {
                Connection connection = activeConnection.connection();
                if (!connection.isOpen()) continue;
                try {
                    connection.close(activeConnection.connectionFactory().getShutdownTimeout());
                }
                catch (Exception e) {
                    LOG.warn("Error closing RabbitMQ connection: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            this.activeConnections.clear();
        }
    }

    private record ActiveConnection(Connection connection, RabbitConnectionFactoryConfig connectionFactory) {
    }
}

