/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.exception;

import io.micronaut.context.annotation.Primary;
import io.micronaut.rabbitmq.bind.RabbitConsumerState;
import io.micronaut.rabbitmq.exception.RabbitListenerException;
import io.micronaut.rabbitmq.exception.RabbitListenerExceptionHandler;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Primary
public class DefaultRabbitListenerExceptionHandler
implements RabbitListenerExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRabbitListenerExceptionHandler.class);

    public void handle(RabbitListenerException exception) {
        if (LOG.isErrorEnabled()) {
            Optional<RabbitConsumerState> messageState = exception.getMessageState();
            if (messageState.isPresent()) {
                LOG.error("Error processing a message for RabbitMQ consumer [" + exception.getListener() + "]", (Throwable)((Object)exception));
            } else {
                LOG.error("RabbitMQ consumer [" + exception.getListener() + "] produced an error", (Throwable)((Object)exception));
            }
        }
    }
}

