/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.connect.recovery;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.AddressResolver;
import com.rabbitmq.client.BlockedCallback;
import com.rabbitmq.client.BlockedListener;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DnsRecordIpAddressResolver;
import com.rabbitmq.client.ExceptionHandler;
import com.rabbitmq.client.ListAddressResolver;
import com.rabbitmq.client.MetricsCollector;
import com.rabbitmq.client.NoOpMetricsCollector;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.SslContextFactory;
import com.rabbitmq.client.UnblockedCallback;
import com.rabbitmq.client.impl.ConnectionParams;
import com.rabbitmq.client.impl.FrameHandlerFactory;
import com.rabbitmq.client.impl.SocketFrameHandlerFactory;
import com.rabbitmq.client.impl.nio.NioParams;
import com.rabbitmq.client.impl.nio.SocketChannelFrameHandlerFactory;
import com.rabbitmq.client.impl.recovery.AutorecoveringConnection;
import com.rabbitmq.client.observation.ObservationCollector;
import io.micronaut.rabbitmq.connect.RabbitConnectionFactoryConfig;
import io.micronaut.rabbitmq.connect.recovery.TemporarilyDownConnection;
import io.micronaut.rabbitmq.connect.recovery.TemporarilyDownIOException;
import io.micronaut.rabbitmq.connect.recovery.TemporarilyDownRuntimeException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.net.SocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TemporarilyDownAutorecoveringConnection
extends AutorecoveringConnection
implements TemporarilyDownConnection {
    private static final Logger LOG = LoggerFactory.getLogger(TemporarilyDownAutorecoveringConnection.class);
    private final Function<Throwable, RuntimeException> sneaky = x -> new TemporarilyDownRuntimeException(this, (Throwable)x);
    private final Function<Throwable, IOException> io = x -> new TemporarilyDownIOException(this, (Throwable)x);
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final List<TemporarilyDownConnection.EventuallyUpListener> eventuallyUpListeners = Collections.synchronizedList(new ArrayList());

    TemporarilyDownAutorecoveringConnection(RabbitConnectionFactoryConfig factory, ExecutorService executor) {
        super(factory.params(executor), TemporarilyDownAutorecoveringConnection.getFrameHandlerFactory(factory, executor), TemporarilyDownAutorecoveringConnection.getAddressResolver(factory), TemporarilyDownAutorecoveringConnection.getMetricsCollector(factory), ObservationCollector.NO_OP);
    }

    private static FrameHandlerFactory getFrameHandlerFactory(RabbitConnectionFactoryConfig factory, ExecutorService executor) {
        SslContextFactory ssl;
        SocketFactory socketFactory;
        int connectionTimeout = factory.getConnectionTimeout();
        NioParams nioParams = factory.getNioParams();
        ConnectionParams params = factory.params(executor);
        int maxInboundMessageBodySize = params.getMaxInboundMessageBodySize();
        if (nioParams.getNioExecutor() != null || nioParams.getThreadFactory() != null) {
            SslContextFactory ssl2;
            SocketFactory socketFactory2;
            return new SocketChannelFrameHandlerFactory(connectionTimeout, nioParams, factory.isSSL(), (socketFactory2 = factory.getSocketFactory()) instanceof SslContextFactory ? (ssl2 = (SslContextFactory)socketFactory2) : null, maxInboundMessageBodySize);
        }
        return new SocketFrameHandlerFactory(connectionTimeout, factory.getSocketFactory(), factory.getSocketConfigurator(), factory.isSSL(), params.getShutdownExecutor(), (socketFactory = factory.getSocketFactory()) instanceof SslContextFactory ? (ssl = (SslContextFactory)socketFactory) : null, maxInboundMessageBodySize);
    }

    private static AddressResolver getAddressResolver(RabbitConnectionFactoryConfig factory) {
        List addressList = factory.getAddresses().filter(Predicate.not(List::isEmpty)).orElseGet(() -> List.of(new Address(factory.getHost(), factory.getPort())));
        if (addressList.size() > 1) {
            return new ListAddressResolver(addressList);
        }
        return new DnsRecordIpAddressResolver((Address)addressList.get(0), factory.isSSL());
    }

    private static MetricsCollector getMetricsCollector(RabbitConnectionFactoryConfig factory) {
        return Optional.ofNullable(factory.getMetricsCollector()).orElseGet(NoOpMetricsCollector::new);
    }

    public InetAddress getAddress() {
        this.checkInitialized(this.sneaky);
        return super.getAddress();
    }

    public int getPort() {
        this.checkInitialized(this.sneaky);
        return super.getPort();
    }

    public int getChannelMax() {
        this.checkInitialized(this.sneaky);
        return super.getChannelMax();
    }

    public int getFrameMax() {
        this.checkInitialized(this.sneaky);
        return super.getFrameMax();
    }

    public int getHeartbeat() {
        this.checkInitialized(this.sneaky);
        return super.getHeartbeat();
    }

    public Map<String, Object> getClientProperties() {
        this.checkInitialized(this.sneaky);
        return super.getClientProperties();
    }

    public String getClientProvidedName() {
        this.checkInitialized(this.sneaky);
        return super.getClientProvidedName();
    }

    public Map<String, Object> getServerProperties() {
        this.checkInitialized(this.sneaky);
        return super.getServerProperties();
    }

    public Channel createChannel() throws IOException {
        this.checkInitialized(this.io);
        return super.createChannel();
    }

    public Channel createChannel(int channelNumber) throws IOException {
        this.checkInitialized(this.io);
        return super.createChannel(channelNumber);
    }

    public void close() throws IOException {
        this.checkInitialized(this.io);
        super.close();
    }

    public void close(int closeCode, String closeMessage) throws IOException {
        this.checkInitialized(this.io);
        super.close(closeCode, closeMessage);
    }

    public void close(int timeout) throws IOException {
        this.checkInitialized(this.io);
        super.close(timeout);
    }

    public void close(int closeCode, String closeMessage, int timeout) throws IOException {
        this.checkInitialized(this.io);
        super.close(closeCode, closeMessage, timeout);
    }

    public void abort() {
        if (this.isStillDown()) {
            LOG.warn("Ignoring connection abort because the connection is still down");
        } else {
            super.abort();
        }
    }

    public void abort(int closeCode, String closeMessage) {
        if (this.isStillDown()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Ignoring connection abort({}, {}) because the connection is still down", (Object)closeCode, (Object)closeMessage);
            }
        } else {
            super.abort(closeCode, closeMessage);
        }
    }

    public void abort(int timeout) {
        if (this.isStillDown()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Ignoring connection abort({}) because the connection is still down", (Object)timeout);
            }
        } else {
            super.abort(timeout);
        }
    }

    public void abort(int closeCode, String closeMessage, int timeout) {
        if (this.isStillDown()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Ignoring connection abort({}, {}, {}) because the connection is still down", new Object[]{closeCode, closeMessage, timeout});
            }
        } else {
            super.abort(closeCode, closeMessage, timeout);
        }
    }

    public void addBlockedListener(BlockedListener listener) {
        this.checkInitialized(this.sneaky);
        super.addBlockedListener(listener);
    }

    public BlockedListener addBlockedListener(BlockedCallback blockedCallback, UnblockedCallback unblockedCallback) {
        this.checkInitialized(this.sneaky);
        return super.addBlockedListener(blockedCallback, unblockedCallback);
    }

    public boolean removeBlockedListener(BlockedListener listener) {
        this.checkInitialized(this.sneaky);
        return super.removeBlockedListener(listener);
    }

    public void clearBlockedListeners() {
        this.checkInitialized(this.sneaky);
        super.clearBlockedListeners();
    }

    public ExceptionHandler getExceptionHandler() {
        this.checkInitialized(this.sneaky);
        return super.getExceptionHandler();
    }

    public String getId() {
        this.checkInitialized(this.sneaky);
        return super.getId();
    }

    public void setId(String id) {
        this.checkInitialized(this.sneaky);
        super.setId(id);
    }

    public void addShutdownListener(ShutdownListener listener) {
        this.checkInitialized(this.sneaky);
        super.addShutdownListener(listener);
    }

    public void removeShutdownListener(ShutdownListener listener) {
        this.checkInitialized(this.sneaky);
        super.removeShutdownListener(listener);
    }

    public ShutdownSignalException getCloseReason() {
        this.checkInitialized(this.sneaky);
        return super.getCloseReason();
    }

    public void notifyListeners() {
        this.checkInitialized(this.sneaky);
        super.notifyListeners();
    }

    public boolean isOpen() {
        this.checkInitialized(this.sneaky);
        return super.isOpen();
    }

    @Override
    public boolean isStillDown() {
        return !this.initialized.get();
    }

    @Override
    public boolean check() {
        return this.checkInitialized(x -> null);
    }

    @Override
    public void addEventuallyUpListener(TemporarilyDownConnection.EventuallyUpListener listener) {
        this.eventuallyUpListeners.add(listener);
    }

    private <E extends Throwable> boolean checkInitialized(Function<Throwable, E> mapper) throws E {
        block3: {
            if (this.isStillDown()) {
                try {
                    return this.initialize();
                }
                catch (Exception e) {
                    Throwable exception = (Throwable)mapper.apply(e);
                    if (exception == null) break block3;
                    throw (Throwable)mapper.apply(e);
                }
            }
        }
        return this.initialized.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initialize() throws IOException, TimeoutException {
        AtomicBoolean atomicBoolean = this.initialized;
        synchronized (atomicBoolean) {
            try {
                if (this.initialized.compareAndSet(false, true)) {
                    super.init();
                    LOG.info("RabbitMQ connection is up now");
                    this.notifyInitialized();
                    return true;
                }
            }
            catch (Exception e) {
                this.initialized.set(false);
                throw e;
            }
        }
        return this.initialized.get();
    }

    private void notifyInitialized() {
        for (TemporarilyDownConnection.EventuallyUpListener listener : this.eventuallyUpListeners) {
            try {
                listener.onConnectionInitialized(this);
            }
            catch (Exception e) {
                LOG.error("Callback threw an exception", (Throwable)e);
            }
        }
    }
}

