/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.health;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ShutdownNotifier;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.endpoint.health.HealthEndpoint;
import io.micronaut.management.health.indicator.AbstractHealthIndicator;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Requirements(value={@Requires(property="endpoints.health.rabbitmq.enabled", notEquals="false"), @Requires(beans={HealthEndpoint.class})})
@Singleton
public class RabbitMQHealthIndicator
extends AbstractHealthIndicator<Map<String, Object>> {
    private final List<Connection> connections;

    public RabbitMQHealthIndicator(Connection connection) {
        this.connections = Collections.singletonList(connection);
    }

    @Inject
    public RabbitMQHealthIndicator(List<Connection> connections) {
        this.connections = connections;
    }

    protected Map<String, Object> getHealthInformation() {
        if (!this.connections.stream().allMatch(ShutdownNotifier::isOpen)) {
            throw new RuntimeException("RabbitMQ connection is not open");
        }
        this.healthStatus = HealthStatus.UP;
        if (this.connections.size() == 1) {
            Connection connection = this.connections.get(0);
            return this.getDetails(connection);
        }
        HashMap<String, Object> healthInfo = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> connectionDetails = new ArrayList<Map<String, Object>>(this.connections.size());
        healthInfo.put("connections", connectionDetails);
        for (Connection connection : this.connections) {
            connectionDetails.add(this.getDetails(connection));
        }
        return healthInfo;
    }

    protected Map<String, Object> getDetails(Connection connection) {
        return connection.getServerProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Object value = entry.getValue();
            if (value instanceof Map) {
                return value;
            }
            return value.toString();
        }));
    }

    protected String getName() {
        return "rabbitmq";
    }
}

