/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.connect.recovery;

import io.micronaut.rabbitmq.connect.RabbitConnectionFactoryConfig;
import io.micronaut.rabbitmq.connect.recovery.TemporarilyDownAutorecoveringConnection;
import io.micronaut.rabbitmq.connect.recovery.TemporarilyDownConnection;
import io.micronaut.scheduling.annotation.Scheduled;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TemporarilyDownConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(TemporarilyDownConnectionManager.class);
    private final List<TemporarilyDownAutorecoveringConnection> connections = Collections.synchronizedList(new ArrayList());

    public TemporarilyDownConnection newConnection(RabbitConnectionFactoryConfig factory, ExecutorService executor) {
        LOG.info("Creating a new temporarily down connection");
        TemporarilyDownAutorecoveringConnection connection = new TemporarilyDownAutorecoveringConnection(factory, executor);
        this.connections.add(connection);
        return connection;
    }

    @Scheduled(initialDelay="PT10S", fixedRate="PT60S")
    void checkConnections() {
        LOG.debug("Checking if temporarily down connections are up now");
        this.connections.parallelStream().filter(TemporarilyDownAutorecoveringConnection::isStillDown).forEach(TemporarilyDownAutorecoveringConnection::check);
    }
}

