/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.intercept;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.rabbitmq.client.AMQP;
import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.messaging.annotation.MessageBody;
import io.micronaut.messaging.annotation.MessageHeader;
import io.micronaut.rabbitmq.annotation.Binding;
import io.micronaut.rabbitmq.annotation.Mandatory;
import io.micronaut.rabbitmq.annotation.RabbitClient;
import io.micronaut.rabbitmq.annotation.RabbitConnection;
import io.micronaut.rabbitmq.annotation.RabbitHeaders;
import io.micronaut.rabbitmq.annotation.RabbitProperty;
import io.micronaut.rabbitmq.bind.RabbitConsumerState;
import io.micronaut.rabbitmq.exception.RabbitClientException;
import io.micronaut.rabbitmq.intercept.MutableBasicProperties;
import io.micronaut.rabbitmq.intercept.StaticPublisherState;
import io.micronaut.rabbitmq.reactive.RabbitPublishState;
import io.micronaut.rabbitmq.reactive.ReactivePublisher;
import io.micronaut.rabbitmq.serdes.RabbitMessageSerDes;
import io.micronaut.rabbitmq.serdes.RabbitMessageSerDesRegistry;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Singleton
public class RabbitMQIntroductionAdvice
implements MethodInterceptor<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQIntroductionAdvice.class);
    private final BeanContext beanContext;
    private final ConversionService conversionService;
    private final RabbitMessageSerDesRegistry serDesRegistry;
    private final Scheduler scheduler;
    private final Map<String, BiConsumer<Object, MutableBasicProperties>> properties = new HashMap<String, BiConsumer<Object, MutableBasicProperties>>();
    private final Cache<ExecutableMethod, StaticPublisherState> publisherCache = Caffeine.newBuilder().build();

    public RabbitMQIntroductionAdvice(BeanContext beanContext, ConversionService conversionService, RabbitMessageSerDesRegistry serDesRegistry, @Named(value="io") ExecutorService executorService) {
        this.beanContext = beanContext;
        this.conversionService = conversionService;
        this.serDesRegistry = serDesRegistry;
        this.scheduler = Schedulers.fromExecutor((Executor)executorService);
        this.properties.put("contentType", (prop, builder) -> this.convert("contentType", prop, String.class, builder::setContentType));
        this.properties.put("contentEncoding", (prop, builder) -> this.convert("contentEncoding", prop, String.class, builder::setContentEncoding));
        this.properties.put("deliveryMode", (prop, builder) -> this.convert("deliveryMode", prop, Integer.class, builder::setDeliveryMode));
        this.properties.put("priority", (prop, builder) -> this.convert("priority", prop, Integer.class, builder::setPriority));
        this.properties.put("correlationId", (prop, builder) -> this.convert("correlationId", prop, String.class, builder::setCorrelationId));
        this.properties.put("replyTo", (prop, builder) -> this.convert("replyTo", prop, String.class, builder::setReplyTo));
        this.properties.put("expiration", (prop, builder) -> this.convert("expiration", prop, String.class, builder::setExpiration));
        this.properties.put("messageId", (prop, builder) -> this.convert("messageId", prop, String.class, builder::setMessageId));
        this.properties.put("timestamp", (prop, builder) -> this.convert("timestamp", prop, Date.class, builder::setTimestamp));
        this.properties.put("type", (prop, builder) -> this.convert("type", prop, String.class, builder::setType));
        this.properties.put("userId", (prop, builder) -> this.convert("userId", prop, String.class, builder::setUserId));
        this.properties.put("appId", (prop, builder) -> this.convert("appId", prop, String.class, builder::setAppId));
        this.properties.put("clusterId", (prop, builder) -> this.convert("clusterId", prop, String.class, builder::setClusterId));
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        if (context.hasAnnotation(RabbitClient.class)) {
            StaticPublisherState publisherState = this.getPublisherState(context);
            String exchange = publisherState.getExchange();
            String routingKey = publisherState.getRoutingKey().or(() -> this.findRoutingKey(context)).orElse("");
            boolean mandatory = publisherState.getMandatory().or(() -> this.findMandatoryFlag(context)).orElse(false);
            Argument bodyArgument = publisherState.getBodyArgument();
            MutableBasicProperties mutableProperties = new MutableBasicProperties();
            Map<String, Object> headers = publisherState.getHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            publisherState.getProperties().forEach((name, value) -> this.setBasicProperty(mutableProperties, (String)name, value));
            Argument[] arguments = context.getArguments();
            Map parameterValues = context.getParameterValueMap();
            for (Argument argument : arguments) {
                String argumentName;
                Object value2;
                String name2;
                Map.Entry<String, Object> entry;
                AnnotationValue headerAnn = argument.getAnnotation(MessageHeader.class);
                AnnotationValue propertyAnn = argument.getAnnotation(RabbitProperty.class);
                boolean headersMap = argument.getAnnotationMetadata().hasAnnotation(RabbitHeaders.class);
                if (headerAnn != null) {
                    entry = this.getNameAndValue(argument, headerAnn, parameterValues);
                    name2 = entry.getKey();
                    value2 = entry.getValue();
                    headers.put(name2, value2);
                    continue;
                }
                if (propertyAnn != null) {
                    entry = this.getNameAndValue(argument, propertyAnn, parameterValues);
                    name2 = entry.getKey();
                    value2 = entry.getValue();
                    this.setBasicProperty(mutableProperties, name2, value2);
                    continue;
                }
                if (headersMap) {
                    if (!argument.equalsType(Argument.mapOf(String.class, Object.class))) {
                        throw new RabbitClientException("The @RabbitHeaders annotation is applied to an argument that is not java.util.Map<String, ?>.");
                    }
                    Object value3 = parameterValues.get(argument.getName());
                    headers.putAll((Map)value3);
                    continue;
                }
                if (argument == bodyArgument || !this.properties.containsKey(argumentName = argument.getName())) continue;
                this.properties.get(argumentName).accept(parameterValues.get(argumentName), mutableProperties);
            }
            if (!headers.isEmpty()) {
                mutableProperties.setHeaders(headers);
            }
            Object body = parameterValues.get(bodyArgument.getName());
            byte[] converted = publisherState.getSerDes().serialize(body, mutableProperties);
            AMQP.BasicProperties properties = mutableProperties.toBasicProperties();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending a message to exchange [{}] with binding [{}] mandatory flag [{}] and properties [{}]", new Object[]{exchange, routingKey, mandatory, properties});
            }
            RabbitPublishState publishState = new RabbitPublishState(exchange, routingKey, mandatory, properties, converted);
            ReactivePublisher reactivePublisher = publisherState.getReactivePublisher();
            InterceptedMethod interceptedMethod = InterceptedMethod.of(context, (ConversionService)this.conversionService);
            try {
                Mono reactive;
                boolean rpc;
                boolean replyToSet = StringUtils.isNotEmpty((CharSequence)properties.getReplyTo());
                boolean bl = rpc = replyToSet && !interceptedMethod.returnTypeValue().isVoid();
                if (rpc) {
                    reactive = Mono.from(reactivePublisher.publishAndReply(publishState)).flatMap(consumerState -> {
                        Object deserialized = this.deserialize((RabbitConsumerState)consumerState, (Argument)publisherState.getDataType(), (Argument)publisherState.getDataType());
                        if (deserialized == null) {
                            return Mono.empty();
                        }
                        return Mono.just((Object)deserialized);
                    });
                    if (interceptedMethod.resultType() == InterceptedMethod.ResultType.SYNCHRONOUS) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Publish is an RPC call. Blocking until a response is received.", context);
                        }
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Publish is an RPC call. Publisher will complete when a response is received.", context);
                        }
                        reactive = reactive.subscribeOn(this.scheduler);
                    }
                } else if (interceptedMethod.resultType() == InterceptedMethod.ResultType.SYNCHRONOUS) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Sending the message without publisher confirms.", context);
                    }
                    reactive = Mono.from(reactivePublisher.publish(publishState));
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Sending the message with publisher confirms.", context);
                    }
                    reactive = Mono.from(reactivePublisher.publishAndConfirm(publishState)).subscribeOn(this.scheduler);
                }
                switch (interceptedMethod.resultType()) {
                    case PUBLISHER: {
                        return interceptedMethod.handleResult((Object)reactive);
                    }
                    case COMPLETION_STAGE: {
                        final CompletableFuture future = new CompletableFuture();
                        reactive.subscribe((Subscriber)new Subscriber<Object>(){
                            Object value = null;

                            public void onSubscribe(Subscription s) {
                                s.request(1L);
                            }

                            public void onNext(Object o) {
                                this.value = o;
                            }

                            public void onError(Throwable t) {
                                future.completeExceptionally(t);
                            }

                            public void onComplete() {
                                future.complete(this.value);
                            }
                        });
                        return interceptedMethod.handleResult(future);
                    }
                    case SYNCHRONOUS: {
                        try {
                            return interceptedMethod.handleResult(reactive.block());
                        }
                        catch (Throwable throwable) {
                            throw new RabbitClientException(String.format("Failed to publish a message with exchange: [%s] routing key [%s] and mandatory flag [%s]", exchange, routingKey, mandatory), throwable, Collections.singletonList(publishState));
                        }
                    }
                }
                return interceptedMethod.unsupported();
            }
            catch (Exception e) {
                return interceptedMethod.handleException(e);
            }
        }
        return context.proceed();
    }

    private StaticPublisherState getPublisherState(MethodInvocationContext<?, ?> context) {
        return (StaticPublisherState)this.publisherCache.get((Object)context.getExecutableMethod(), method -> {
            ReactivePublisher reactivePublisher;
            AnnotationValue client = (AnnotationValue)method.findAnnotation(RabbitClient.class).orElseThrow(() -> new IllegalStateException("No @RabbitClient annotation present on method: " + String.valueOf(method)));
            String exchange = client.getValue(String.class).orElse("");
            Optional bindingAnn = method.findAnnotation(Binding.class);
            Optional mandatoryAnn = method.findAnnotation(Mandatory.class);
            Optional routingKey = bindingAnn.flatMap(b -> b.getValue(String.class));
            Optional mandatory = mandatoryAnn.flatMap(m -> m.getValue(Boolean.class));
            String connection = method.findAnnotation(RabbitConnection.class).flatMap(conn -> conn.stringValue("connection")).orElse("default");
            Argument<?> bodyArgument = this.findBodyArgument((ExecutableMethod<?, ?>)method).orElseThrow(() -> new RabbitClientException("No valid message body argument found for method: " + String.valueOf(method)));
            HashMap<String, Object> methodHeaders = new HashMap<String, Object>();
            List headerAnnotations = method.getAnnotationValuesByType(MessageHeader.class);
            Collections.reverse(headerAnnotations);
            headerAnnotations.forEach(header -> {
                String name = header.stringValue("name").orElse(null);
                String value = header.stringValue().orElse(null);
                if (StringUtils.isNotEmpty((CharSequence)name) && StringUtils.isNotEmpty((CharSequence)value)) {
                    methodHeaders.put(name, value);
                }
            });
            HashMap<String, String> methodProperties = new HashMap<String, String>();
            List propertyAnnotations = method.getAnnotationValuesByType(RabbitProperty.class);
            Collections.reverse(propertyAnnotations);
            propertyAnnotations.forEach(prop -> {
                String name = prop.stringValue("name").orElse(null);
                String value = prop.stringValue().orElse(null);
                if (StringUtils.isNotEmpty((CharSequence)name) && StringUtils.isNotEmpty((CharSequence)value)) {
                    if (this.properties.containsKey(name)) {
                        methodProperties.put(name, value);
                    } else {
                        throw new RabbitClientException(String.format("Attempted to set property [%s], but could not match the name to any of the com.rabbitmq.client.BasicProperties", name));
                    }
                }
            });
            RabbitMessageSerDes<?> serDes = this.serDesRegistry.findSerdes(bodyArgument).orElseThrow(() -> new RabbitClientException(String.format("Could not find a serializer for the body argument of type [%s]", bodyArgument.getType().getName())));
            try {
                reactivePublisher = (ReactivePublisher)this.beanContext.getBean(ReactivePublisher.class, Qualifiers.byName((String)connection));
            }
            catch (Throwable e) {
                throw new RabbitClientException(String.format("Failed to retrieve a publisher named [%s] to publish messages", connection), e);
            }
            return new StaticPublisherState(exchange, routingKey.orElse(null), mandatory.orElse(null), bodyArgument, methodHeaders, methodProperties, method.getReturnType(), serDes, reactivePublisher);
        });
    }

    private Object deserialize(RabbitConsumerState consumerState, Argument dataType, Argument returnType) {
        Optional serDes = this.serDesRegistry.findSerdes(dataType);
        if (serDes.isPresent()) {
            return serDes.get().deserialize(consumerState, returnType);
        }
        throw new RabbitClientException(String.format("Could not find a deserializer for [%s]", dataType.getName()));
    }

    private Map.Entry<String, Object> getNameAndValue(Argument argument, AnnotationValue<?> annotationValue, Map<String, Object> parameterValues) {
        String argumentName = argument.getName();
        String name = annotationValue.stringValue("name").orElse(annotationValue.stringValue().orElse(argumentName));
        Object value = parameterValues.get(argumentName);
        return new AbstractMap.SimpleEntry<String, Object>(name, value);
    }

    private void setBasicProperty(MutableBasicProperties mutableProperties, String name, Object value) {
        BiConsumer<Object, MutableBasicProperties> consumer = this.properties.get(name);
        if (consumer == null) {
            throw new RabbitClientException(String.format("Attempted to set property [%s], but could not match the name to any of the com.rabbitmq.client.BasicProperties", name));
        }
        consumer.accept(value, mutableProperties);
    }

    private <T> void convert(String name, Object value, Class<T> type, Consumer<? super T> consumer) {
        if (value == null) {
            consumer.accept(null);
        } else {
            consumer.accept(this.conversionService.convert(value, type).orElseThrow(() -> new RabbitClientException(String.format("Attempted to set property [%s], but could not convert the value to the required type [%s]", name, type.getName()))));
        }
    }

    private Optional<String> findRoutingKey(MethodInvocationContext<Object, Object> method) {
        Map argumentValues = method.getParameterValueMap();
        return Arrays.stream(method.getArguments()).filter(arg -> arg.getAnnotationMetadata().hasAnnotation(Binding.class)).map(Argument::getName).map(argumentValues::get).filter(Objects::nonNull).map(Object::toString).findFirst();
    }

    private Optional<Boolean> findMandatoryFlag(MethodInvocationContext<Object, Object> method) {
        Map argumentValues = method.getParameterValueMap();
        return Arrays.stream(method.getArguments()).filter(arg -> arg.getAnnotationMetadata().hasAnnotation(Mandatory.class)).map(Argument::getName).map(argumentValues::get).filter(Objects::nonNull).map(Object::toString).map("true"::equalsIgnoreCase).findFirst();
    }

    private Optional<Argument<?>> findBodyArgument(ExecutableMethod<?, ?> method) {
        return Optional.ofNullable(Arrays.stream(method.getArguments()).filter(arg -> arg.getAnnotationMetadata().hasAnnotation(MessageBody.class)).findFirst().orElseGet(() -> Arrays.stream(method.getArguments()).filter(arg -> !arg.getAnnotationMetadata().hasStereotype(Bindable.class)).filter(arg -> !this.properties.containsKey(arg.getName())).findFirst().orElse(null)));
    }
}

