/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.intercept;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.rabbitmq.reactive.ReactivePublisher;
import io.micronaut.rabbitmq.serdes.RabbitMessageSerDes;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

@Internal
class StaticPublisherState {
    private final String exchange;
    private final String routingKey;
    private final Boolean mandatory;
    private final Argument bodyArgument;
    private final Map<String, Object> headers;
    private final Map<String, String> properties;
    private final ReactivePublisher reactivePublisher;
    private final boolean reactive;
    private final ReturnType<?> returnType;
    private final Argument<?> dataType;
    private final RabbitMessageSerDes<?> serDes;

    StaticPublisherState(String exchange, @Nullable String routingKey, @Nullable Boolean mandatory, Argument bodyArgument, Map<String, Object> headers, Map<String, String> properties, ReturnType<?> returnType, RabbitMessageSerDes<?> serDes, ReactivePublisher reactivePublisher) {
        this.exchange = exchange;
        this.routingKey = routingKey;
        this.mandatory = mandatory;
        this.bodyArgument = bodyArgument;
        this.headers = Collections.unmodifiableMap(headers);
        this.properties = Collections.unmodifiableMap(properties);
        this.reactivePublisher = reactivePublisher;
        Class javaReturnType = returnType.getType();
        this.reactive = Publishers.isConvertibleToPublisher((Class)javaReturnType);
        this.dataType = this.reactive ? returnType.getFirstTypeVariable().orElse(Argument.VOID) : returnType.asArgument();
        this.returnType = returnType;
        this.serDes = serDes;
    }

    String getExchange() {
        return this.exchange;
    }

    Optional<String> getRoutingKey() {
        return Optional.ofNullable(this.routingKey);
    }

    Optional<Boolean> getMandatory() {
        return Optional.ofNullable(this.mandatory);
    }

    Argument getBodyArgument() {
        return this.bodyArgument;
    }

    Map<String, Object> getHeaders() {
        return this.headers;
    }

    Map<String, String> getProperties() {
        return this.properties;
    }

    boolean isReactive() {
        return this.reactive;
    }

    RabbitMessageSerDes<Object> getSerDes() {
        return this.serDes;
    }

    Argument<?> getDataType() {
        return this.dataType;
    }

    ReturnType<?> getReturnType() {
        return this.returnType;
    }

    ReactivePublisher getReactivePublisher() {
        return this.reactivePublisher;
    }
}

