/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.serdes;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.serialize.exceptions.SerializationException;
import io.micronaut.core.type.Argument;
import io.micronaut.json.JsonMapper;
import io.micronaut.rabbitmq.bind.RabbitConsumerState;
import io.micronaut.rabbitmq.intercept.MutableBasicProperties;
import io.micronaut.rabbitmq.serdes.RabbitMessageSerDes;
import jakarta.inject.Singleton;
import java.io.IOException;

@Requires(bean=JsonMapper.class)
@Singleton
public class JsonRabbitMessageSerDes
implements RabbitMessageSerDes<Object> {
    public static final Integer ORDER = 200;
    private final JsonMapper jsonMapper;

    public JsonRabbitMessageSerDes(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    @Override
    public Object deserialize(RabbitConsumerState messageState, Argument<Object> type) {
        byte[] body = messageState.getBody();
        if (body == null || body.length == 0) {
            return null;
        }
        try {
            return this.jsonMapper.readValue(body, type);
        }
        catch (IOException e) {
            throw new SerializationException("Error decoding JSON stream for type [" + type.getName() + "]: " + e.getMessage());
        }
    }

    @Override
    public byte[] serialize(Object data, MutableBasicProperties basicProperties) {
        if (data == null) {
            return null;
        }
        try {
            byte[] serialized = this.jsonMapper.writeValueAsBytes(data);
            if (serialized != null && basicProperties.getContentType() == null) {
                basicProperties.setContentType("application/json");
            }
            return serialized;
        }
        catch (IOException e) {
            throw new SerializationException("Error encoding object [" + String.valueOf(data) + "] to JSON: " + e.getMessage());
        }
    }

    public int getOrder() {
        return ORDER;
    }

    @Override
    public boolean supports(Argument<Object> argument) {
        return !ClassUtils.isJavaBasicType((Class)argument.getType());
    }
}

