/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactor.http.client;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.HttpClient;
import io.micronaut.reactor.http.client.ReactorHttpClient;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Internal
class BridgedReactorHttpClient
implements ReactorHttpClient {
    private final HttpClient httpClient;

    BridgedReactorHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public BlockingHttpClient toBlocking() {
        return this.httpClient.toBlocking();
    }

    @Override
    public <I, O, E> Flux<HttpResponse<O>> exchange(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType, @NonNull Argument<E> errorType) {
        return Flux.from((Publisher)this.httpClient.exchange(request, bodyType, errorType));
    }

    @Override
    public <I, O> Flux<HttpResponse<O>> exchange(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType) {
        return Flux.from((Publisher)this.httpClient.exchange(request, bodyType));
    }

    @Override
    public <I, O, E> Flux<O> retrieve(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType, @NonNull Argument<E> errorType) {
        return Flux.from((Publisher)this.httpClient.retrieve(request, bodyType));
    }

    @Override
    public <I> Flux<HttpResponse<ByteBuffer>> exchange(@NonNull HttpRequest<I> request) {
        return Flux.from((Publisher)this.httpClient.exchange(request));
    }

    @Override
    public Flux<HttpResponse<ByteBuffer>> exchange(@NonNull String uri) {
        return Flux.from((Publisher)this.httpClient.exchange(uri));
    }

    @Override
    public <O> Flux<HttpResponse<O>> exchange(@NonNull String uri, @NonNull Class<O> bodyType) {
        return Flux.from((Publisher)this.httpClient.exchange(uri, bodyType));
    }

    @Override
    public <I, O> Flux<HttpResponse<O>> exchange(@NonNull HttpRequest<I> request, @NonNull Class<O> bodyType) {
        return Flux.from((Publisher)this.httpClient.exchange(request, bodyType));
    }

    @Override
    public <I, O> Flux<O> retrieve(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType) {
        return Flux.from((Publisher)this.httpClient.retrieve(request, bodyType));
    }

    @Override
    public <I, O> Flux<O> retrieve(@NonNull HttpRequest<I> request, @NonNull Class<O> bodyType) {
        return Flux.from((Publisher)this.httpClient.retrieve(request, bodyType));
    }

    @Override
    public <I> Flux<String> retrieve(@NonNull HttpRequest<I> request) {
        return Flux.from((Publisher)this.httpClient.retrieve(request));
    }

    @Override
    public Flux<String> retrieve(@NonNull String uri) {
        return Flux.from((Publisher)this.httpClient.retrieve(uri));
    }

    public boolean isRunning() {
        return this.httpClient.isRunning();
    }
}

