/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactor.http.client.websocket;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.reactor.http.client.websocket.BridgedReactorWebSocketClient;
import io.micronaut.reactor.http.client.websocket.ReactorWebSocketClient;
import io.micronaut.websocket.WebSocketClientRegistry;

@Factory
public class ReactorWebSocketClientFactory {
    private final WebSocketClientRegistry<?> clientRegistry;

    public ReactorWebSocketClientFactory(WebSocketClientRegistry<?> clientRegistry) {
        this.clientRegistry = clientRegistry;
    }

    @Bean
    @Secondary
    protected ReactorWebSocketClient webSocketClient(@Nullable InjectionPoint<?> injectionPoint, @Parameter @Nullable LoadBalancer loadBalancer, @Parameter @Nullable HttpClientConfiguration configuration, BeanContext beanContext) {
        return new BridgedReactorWebSocketClient(this.clientRegistry.resolveWebSocketClient(injectionPoint, loadBalancer, configuration, beanContext));
    }
}

