/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactor.convert;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import java.util.Optional;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Singleton
@Internal
@Requirements(value={@Requires(sdk=Requires.Sdk.MICRONAUT, version="2.0.0"), @Requires(classes={Flux.class})})
@TypeHint(value={Flux.class, Mono.class})
class ReactorConverterRegistrar
implements TypeConverterRegistrar {
    ReactorConverterRegistrar() {
    }

    public void register(ConversionService<?> conversionService) {
        conversionService.addConverter(Mono.class, Maybe.class, (object, targetType, context) -> Optional.of(Flowable.fromPublisher((Publisher)object).firstElement()));
        conversionService.addConverter(Publisher.class, Flux.class, (object, targetType, context) -> Optional.of(Flux.from((Publisher)object)));
        conversionService.addConverter(Publisher.class, Mono.class, (object, targetType, context) -> Optional.of(Mono.from((Publisher)object)));
        conversionService.addConverter(Object.class, Flux.class, (object, targetType, context) -> Optional.of(Flux.just((Object)object)));
        conversionService.addConverter(Object.class, Mono.class, (object, targetType, context) -> Optional.of(Mono.just((Object)object)));
    }
}

