/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.resource.ClientResources;
import io.micronaut.configuration.lettuce.AbstractRedisConfiguration;
import java.util.Optional;
import javax.annotation.Nullable;

public abstract class AbstractRedisClientFactory {
    public RedisClient redisClient(AbstractRedisConfiguration config) {
        Optional<RedisURI> uri = config.getUri();
        return uri.map(RedisClient::create).orElseGet(() -> RedisClient.create((RedisURI)config));
    }

    public RedisClient redisClient(AbstractRedisConfiguration config, @Nullable ClientResources optionalClientResources) {
        ClientResources clientResources = this.configureClientResources(config, optionalClientResources);
        if (clientResources == null) {
            return this.redisClient(config);
        }
        Optional<RedisURI> uri = config.getUri();
        return uri.map(redisURI -> RedisClient.create((ClientResources)clientResources, (RedisURI)redisURI)).orElseGet(() -> RedisClient.create((ClientResources)clientResources, (RedisURI)config));
    }

    public StatefulRedisConnection<String, String> redisConnection(RedisClient redisClient) {
        return redisClient.connect();
    }

    public StatefulRedisPubSubConnection<String, String> redisPubSubConnection(RedisClient redisClient) {
        return redisClient.connectPubSub();
    }

    @Nullable
    private ClientResources configureClientResources(AbstractRedisConfiguration config, @Nullable ClientResources clientResources) {
        if (config.getIoThreadPoolSize() != null || config.getComputationThreadPoolSize() != null) {
            ClientResources.Builder clientResourcesBuilder;
            ClientResources.Builder builder = clientResourcesBuilder = clientResources == null ? ClientResources.builder() : clientResources.mutate();
            if (config.getIoThreadPoolSize() != null) {
                clientResourcesBuilder.ioThreadPoolSize(config.getIoThreadPoolSize().intValue());
            }
            if (config.getComputationThreadPoolSize() != null) {
                clientResourcesBuilder.computationThreadPoolSize(config.getComputationThreadPoolSize().intValue());
            }
            return clientResourcesBuilder.build();
        }
        return clientResources;
    }
}

