/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce;

import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.resource.ClientResources;
import io.micronaut.configuration.lettuce.AbstractRedisClientFactory;
import io.micronaut.configuration.lettuce.AbstractRedisConfiguration;
import io.micronaut.configuration.lettuce.DefaultRedisConfiguration;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import javax.annotation.Nullable;
import javax.inject.Singleton;

@Requirements(value={@Requires(beans={DefaultRedisConfiguration.class}), @Requires(missingProperty="redis.uris")})
@Singleton
@Factory
public class DefaultRedisClientFactory
extends AbstractRedisClientFactory {
    @Override
    @Bean(preDestroy="shutdown")
    @Singleton
    @Primary
    public RedisClient redisClient(@Primary AbstractRedisConfiguration config, @Nullable @Primary ClientResources defaultClientResources) {
        return super.redisClient(config, defaultClientResources);
    }

    @Override
    @Bean(preDestroy="close")
    @Singleton
    @Primary
    public StatefulRedisConnection<String, String> redisConnection(@Primary RedisClient redisClient) {
        return super.redisConnection(redisClient);
    }

    @Override
    @Bean(preDestroy="close")
    @Singleton
    public StatefulRedisPubSubConnection<String, String> redisPubSubConnection(@Primary RedisClient redisClient) {
        return super.redisPubSubConnection(redisClient);
    }
}

