/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce.cache;

import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.async.RedisKeyAsyncCommands;
import io.lettuce.core.api.async.RedisStringAsyncCommands;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.api.sync.RedisKeyCommands;
import io.lettuce.core.api.sync.RedisStringCommands;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.async.RedisAdvancedClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisAdvancedClusterCommands;
import io.micronaut.cache.AsyncCache;
import io.micronaut.cache.SyncCache;
import io.micronaut.cache.serialize.DefaultStringKeySerializer;
import io.micronaut.configuration.lettuce.RedisConnectionUtil;
import io.micronaut.configuration.lettuce.cache.DefaultRedisCacheConfiguration;
import io.micronaut.configuration.lettuce.cache.RedisCacheConfiguration;
import io.micronaut.configuration.lettuce.cache.expiration.ConstantExpirationAfterWritePolicy;
import io.micronaut.configuration.lettuce.cache.expiration.ExpirationAfterWritePolicy;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.serialize.JdkSerializer;
import io.micronaut.core.serialize.ObjectSerializer;
import io.micronaut.core.type.Argument;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;

@EachBean(value=RedisCacheConfiguration.class)
@Requires(classes={SyncCache.class})
public class RedisCache
implements SyncCache<StatefulConnection<?, ?>>,
AutoCloseable {
    private final RedisCacheConfiguration redisCacheConfiguration;
    private final ObjectSerializer keySerializer;
    private final ObjectSerializer valueSerializer;
    private final ExpirationAfterWritePolicy expireAfterWritePolicy;
    private final Long expireAfterAccess;
    private final RedisAsyncCache asyncCache;
    private final StatefulConnection<byte[], byte[]> connection;
    private final RedisKeyCommands<byte[], byte[]> redisKeyCommands;
    private final RedisStringCommands<byte[], byte[]> redisStringCommands;
    private final RedisKeyAsyncCommands<byte[], byte[]> redisKeyAsyncCommands;
    private final RedisStringAsyncCommands<byte[], byte[]> redisStringAsyncCommands;

    public RedisCache(DefaultRedisCacheConfiguration defaultRedisCacheConfiguration, RedisCacheConfiguration redisCacheConfiguration, ConversionService<?> conversionService, BeanLocator beanLocator) {
        if (redisCacheConfiguration == null) {
            throw new IllegalArgumentException("Redis cache configuration cannot be null");
        }
        this.redisCacheConfiguration = redisCacheConfiguration;
        this.expireAfterWritePolicy = this.configureExpirationAfterWritePolicy(redisCacheConfiguration, beanLocator);
        this.expireAfterAccess = redisCacheConfiguration.getExpireAfterAccess().map(Duration::toMillis).orElse(defaultRedisCacheConfiguration.getExpireAfterAccess().map(Duration::toMillis).orElse(null));
        this.keySerializer = (ObjectSerializer)redisCacheConfiguration.getKeySerializer().flatMap(arg_0 -> ((BeanLocator)beanLocator).findOrInstantiateBean(arg_0)).orElse(defaultRedisCacheConfiguration.getKeySerializer().flatMap(arg_0 -> ((BeanLocator)beanLocator).findOrInstantiateBean(arg_0)).orElse(this.newDefaultKeySerializer(redisCacheConfiguration, conversionService)));
        this.valueSerializer = (ObjectSerializer)redisCacheConfiguration.getValueSerializer().flatMap(arg_0 -> ((BeanLocator)beanLocator).findOrInstantiateBean(arg_0)).orElse(defaultRedisCacheConfiguration.getValueSerializer().flatMap(arg_0 -> ((BeanLocator)beanLocator).findOrInstantiateBean(arg_0)).orElse(new JdkSerializer(conversionService)));
        Optional<Object> server = Optional.ofNullable(redisCacheConfiguration.getServer().orElse(defaultRedisCacheConfiguration.getServer().orElse(null)));
        this.connection = RedisConnectionUtil.openBytesRedisConnection(beanLocator, server, "No Redis server configured to allow caching");
        this.asyncCache = new RedisAsyncCache();
        if (this.connection instanceof StatefulRedisConnection) {
            RedisAsyncCommands async;
            RedisCommands sync;
            this.redisStringCommands = sync = ((StatefulRedisConnection)this.connection).sync();
            this.redisKeyCommands = sync;
            this.redisKeyAsyncCommands = async = ((StatefulRedisConnection)this.connection).async();
            this.redisStringAsyncCommands = async;
        } else if (this.connection instanceof StatefulRedisClusterConnection) {
            RedisAdvancedClusterAsyncCommands async;
            RedisAdvancedClusterCommands sync;
            this.redisStringCommands = sync = ((StatefulRedisClusterConnection)this.connection).sync();
            this.redisKeyCommands = sync;
            this.redisKeyAsyncCommands = async = ((StatefulRedisClusterConnection)this.connection).async();
            this.redisStringAsyncCommands = async;
        } else {
            throw new ConfigurationException("Invalid Redis connection");
        }
    }

    private ExpirationAfterWritePolicy configureExpirationAfterWritePolicy(RedisCacheConfiguration redisCacheConfiguration, BeanLocator beanLocator) {
        if (redisCacheConfiguration.getExpireAfterWrite().isPresent()) {
            Duration expiration = redisCacheConfiguration.getExpireAfterWrite().get();
            return new ConstantExpirationAfterWritePolicy(expiration.toMillis());
        }
        if (redisCacheConfiguration.getExpirationAfterWritePolicy().isPresent()) {
            return (ExpirationAfterWritePolicy)redisCacheConfiguration.getExpirationAfterWritePolicy().flatMap(className -> this.findExpirationAfterWritePolicyBean(beanLocator, (String)className)).get();
        }
        return null;
    }

    private Optional<?> findExpirationAfterWritePolicyBean(BeanLocator beanLocator, String className) {
        try {
            Optional bean = beanLocator.findOrInstantiateBean(Class.forName(className));
            if (bean.isPresent()) {
                if (bean.get() instanceof ExpirationAfterWritePolicy) {
                    return bean;
                }
                throw new ConfigurationException("Redis expiration-after-write-policy was not of type ExpirationAfterWritePolicy");
            }
            throw new ConfigurationException("Redis expiration-after-write-policy was not found");
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Redis expiration-after-write-policy was not found");
        }
    }

    public String getName() {
        return this.redisCacheConfiguration.getCacheName();
    }

    public StatefulConnection<?, ?> getNativeCache() {
        return this.connection;
    }

    public <T> Optional<T> get(Object key, Argument<T> requiredType) {
        byte[] serializedKey = this.serializeKey(key);
        return this.getValue(requiredType, serializedKey);
    }

    public <T> T get(Object key, Argument<T> requiredType, Supplier<T> supplier) {
        Optional deserialized;
        byte[] serializedKey = this.serializeKey(key);
        byte[] data = (byte[])this.redisStringCommands.get((Object)serializedKey);
        if (data != null && (deserialized = this.valueSerializer.deserialize(data, requiredType)).isPresent()) {
            return deserialized.get();
        }
        T value = supplier.get();
        this.putValue(serializedKey, value);
        return value;
    }

    public <T> Optional<T> putIfAbsent(Object key, T value) {
        if (value == null) {
            return Optional.empty();
        }
        byte[] serializedKey = this.serializeKey(key);
        Optional<T> existing = this.getValue(Argument.of(value.getClass()), serializedKey);
        if (!existing.isPresent()) {
            this.putValue(serializedKey, value);
            return Optional.empty();
        }
        return existing;
    }

    public void put(Object key, Object value) {
        byte[] serializedKey = this.serializeKey(key);
        this.putValue(serializedKey, value);
    }

    public void invalidate(Object key) {
        byte[] serializedKey = this.serializeKey(key);
        this.redisKeyCommands.del((Object[])new byte[][]{serializedKey});
    }

    public void invalidateAll() {
        List keys = this.redisKeyCommands.keys((Object)this.getKeysPattern().getBytes(this.redisCacheConfiguration.getCharset()));
        if (!keys.isEmpty()) {
            this.redisKeyCommands.del((Object[])keys.toArray((T[])new byte[keys.size()][]));
        }
    }

    public AsyncCache<StatefulConnection<?, ?>> async() {
        return this.asyncCache;
    }

    protected <T> Optional<T> getValue(Argument<T> requiredType, byte[] serializedKey) {
        byte[] data = (byte[])this.redisStringCommands.get((Object)serializedKey);
        if (this.expireAfterAccess != null) {
            this.redisKeyCommands.pexpire((Object)serializedKey, this.expireAfterAccess.longValue());
        }
        if (data != null) {
            return this.valueSerializer.deserialize(data, requiredType);
        }
        return Optional.empty();
    }

    protected String getKeysPattern() {
        return this.getName() + ":*";
    }

    protected <T> void putValue(byte[] serializedKey, T value) {
        Optional serialized = this.valueSerializer.serialize(value);
        if (serialized.isPresent()) {
            byte[] bytes = (byte[])serialized.get();
            if (this.expireAfterWritePolicy != null) {
                this.redisStringCommands.psetex((Object)serializedKey, this.expireAfterWritePolicy.getExpirationAfterWrite(value), (Object)bytes);
            } else {
                this.redisStringCommands.set((Object)serializedKey, (Object)bytes);
            }
        } else {
            this.redisKeyCommands.del((Object[])new byte[][]{serializedKey});
        }
    }

    protected byte[] serializeKey(Object key) {
        return (byte[])this.keySerializer.serialize(key).orElseThrow(() -> new IllegalArgumentException("Key cannot be null"));
    }

    private DefaultStringKeySerializer newDefaultKeySerializer(RedisCacheConfiguration redisCacheConfiguration, ConversionService<?> conversionService) {
        return new DefaultStringKeySerializer(redisCacheConfiguration.getCacheName(), redisCacheConfiguration.getCharset(), conversionService);
    }

    @Override
    @PreDestroy
    public void close() {
        this.connection.close();
    }

    protected class RedisAsyncCache
    implements AsyncCache<StatefulConnection<?, ?>> {
        protected RedisAsyncCache() {
        }

        public <T> CompletableFuture<Optional<T>> get(Object key, Argument<T> requiredType) {
            byte[] serializedKey = RedisCache.this.serializeKey(key);
            return RedisCache.this.redisStringAsyncCommands.get((Object)serializedKey).thenCompose(data -> {
                if (data != null) {
                    return this.getWithExpire(requiredType, serializedKey, (byte[])data);
                }
                return CompletableFuture.completedFuture(Optional.empty());
            }).toCompletableFuture();
        }

        public <T> CompletableFuture<T> get(Object key, Argument<T> requiredType, Supplier<T> supplier) {
            byte[] serializedKey = RedisCache.this.serializeKey(key);
            return RedisCache.this.redisStringAsyncCommands.get((Object)serializedKey).thenCompose(data -> {
                if (data != null) {
                    Optional deserialized = RedisCache.this.valueSerializer.deserialize(data, requiredType);
                    boolean hasValue = deserialized.isPresent();
                    if (RedisCache.this.expireAfterAccess != null && hasValue) {
                        return RedisCache.this.redisKeyAsyncCommands.expire((Object)serializedKey, RedisCache.this.expireAfterAccess.longValue()).thenApply(ignore -> deserialized.get());
                    }
                    if (hasValue) {
                        return CompletableFuture.completedFuture(deserialized.get());
                    }
                }
                return this.putFromSupplier(serializedKey, supplier);
            }).toCompletableFuture();
        }

        public <T> CompletableFuture<Optional<T>> putIfAbsent(Object key, T value) {
            byte[] serializedKey = RedisCache.this.serializeKey(key);
            return RedisCache.this.redisStringAsyncCommands.get((Object)serializedKey).thenCompose(data -> {
                if (data != null) {
                    return this.getWithExpire((Argument)Argument.of(value.getClass()), serializedKey, (byte[])data);
                }
                Optional serialized = RedisCache.this.valueSerializer.serialize(value);
                if (serialized.isPresent()) {
                    return this.putWithExpire(serializedKey, (byte[])serialized.get(), value).thenApply(ignore -> Optional.of(value));
                }
                return CompletableFuture.completedFuture(Optional.empty());
            }).toCompletableFuture();
        }

        public CompletableFuture<Boolean> put(Object key, Object value) {
            byte[] serializedKey = RedisCache.this.serializeKey(key);
            Optional serialized = RedisCache.this.valueSerializer.serialize(value);
            if (serialized.isPresent()) {
                return this.putWithExpire(serializedKey, (byte[])serialized.get(), value).toCompletableFuture();
            }
            return this.deleteByKeys(new byte[][]{serializedKey});
        }

        public CompletableFuture<Boolean> invalidate(Object key) {
            return this.deleteByKeys(new byte[][]{RedisCache.this.serializeKey(key)});
        }

        public CompletableFuture<Boolean> invalidateAll() {
            return RedisCache.this.redisKeyAsyncCommands.keys((Object)RedisCache.this.getKeysPattern().getBytes(RedisCache.this.redisCacheConfiguration.getCharset())).thenCompose(keys -> this.deleteByKeys((byte[][])keys.toArray((T[])new byte[keys.size()][]))).toCompletableFuture();
        }

        private CompletableFuture<Boolean> deleteByKeys(byte[] ... serializedKey) {
            return RedisCache.this.redisKeyAsyncCommands.del((Object[])serializedKey).thenApply(keysDeleted -> keysDeleted > 0L).toCompletableFuture();
        }

        public String getName() {
            return RedisCache.this.getName();
        }

        public StatefulConnection<?, ?> getNativeCache() {
            return RedisCache.this.getNativeCache();
        }

        private <T> CompletionStage<Optional<T>> getWithExpire(Argument<T> requiredType, byte[] serializedKey, byte[] data) {
            Optional deserialized = RedisCache.this.valueSerializer.deserialize(data, requiredType);
            if (RedisCache.this.expireAfterAccess != null && deserialized.isPresent()) {
                return RedisCache.this.redisKeyAsyncCommands.expire((Object)serializedKey, RedisCache.this.expireAfterAccess.longValue()).thenApply(ignore -> deserialized);
            }
            return CompletableFuture.completedFuture(deserialized);
        }

        private <T> CompletionStage<T> putFromSupplier(byte[] serializedKey, Supplier<T> supplier) {
            return this.supply(supplier).thenCompose(value -> {
                Optional serialized = RedisCache.this.valueSerializer.serialize(value);
                if (serialized.isPresent()) {
                    return this.putWithExpire(serializedKey, (byte[])serialized.get(), value).thenApply(ignore -> value);
                }
                return CompletableFuture.completedFuture(null);
            });
        }

        private <T> CompletionStage<T> supply(Supplier<T> supplier) {
            CompletableFuture<T> completableFuture = new CompletableFuture<T>();
            try {
                completableFuture.complete(supplier.get());
            }
            catch (Throwable e) {
                completableFuture.completeExceptionally(e);
            }
            return completableFuture;
        }

        private CompletionStage<Boolean> putWithExpire(byte[] serializedKey, byte[] serialized, Object value) {
            if (RedisCache.this.expireAfterWritePolicy != null) {
                return RedisCache.this.redisStringAsyncCommands.psetex((Object)serializedKey, RedisCache.this.expireAfterWritePolicy.getExpirationAfterWrite(value), (Object)serialized).thenApply(this.isOK());
            }
            return RedisCache.this.redisStringAsyncCommands.set((Object)serializedKey, (Object)serialized).thenApply(this.isOK());
        }

        private Function<String, Boolean> isOK() {
            return "OK"::equals;
        }
    }
}

