/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce;

import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.resource.ClientResources;
import io.micronaut.configuration.lettuce.AbstractRedisClientFactory;
import io.micronaut.configuration.lettuce.ClientResourcesMutator;
import io.micronaut.configuration.lettuce.NamedRedisServersConfiguration;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.List;

@Factory
public class NamedRedisClientFactory
extends AbstractRedisClientFactory {
    private final BeanLocator beanLocator;
    private final ClientResources defaultClientResources;

    public NamedRedisClientFactory(BeanLocator beanLocator, @Primary @Nullable ClientResources defaultClientResources) {
        this.beanLocator = beanLocator;
        this.defaultClientResources = defaultClientResources;
    }

    @Bean(preDestroy="shutdown")
    @EachBean(value=NamedRedisServersConfiguration.class)
    public RedisClient redisClient(NamedRedisServersConfiguration config, @Nullable List<ClientResourcesMutator> mutators) {
        return super.redisClient(config, this.getClientResources(config), mutators);
    }

    @Bean(preDestroy="close")
    @EachBean(value=NamedRedisServersConfiguration.class)
    public StatefulRedisConnection<String, String> redisConnection(NamedRedisServersConfiguration config) {
        return super.redisConnection(this.getRedisClient(config));
    }

    @Bean(preDestroy="close")
    @EachBean(value=NamedRedisServersConfiguration.class)
    public StatefulRedisPubSubConnection<String, String> redisPubSubConnection(NamedRedisServersConfiguration config) {
        return super.redisPubSubConnection(this.getRedisClient(config));
    }

    @Nullable
    private ClientResources getClientResources(NamedRedisServersConfiguration config) {
        return this.beanLocator.findBean(ClientResources.class, Qualifiers.byName((String)config.getName())).orElse(this.defaultClientResources);
    }

    private RedisClient getRedisClient(NamedRedisServersConfiguration config) {
        return (RedisClient)this.beanLocator.getBean(RedisClient.class, Qualifiers.byName((String)config.getName()));
    }
}

