/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce.cache;

import io.micronaut.core.serialize.ObjectSerializer;
import io.micronaut.runtime.ApplicationConfiguration;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Optional;

public abstract class AbstractRedisCacheConfiguration {
    protected String server;
    protected Class<ObjectSerializer> keySerializer;
    protected Class<ObjectSerializer> valueSerializer;
    protected Charset charset;
    protected Duration expireAfterWrite;
    protected Duration expireAfterAccess;
    protected String expirationAfterWritePolicy;

    public AbstractRedisCacheConfiguration(ApplicationConfiguration applicationConfiguration) {
        this.charset = applicationConfiguration.getDefaultCharset();
    }

    public Optional<String> getServer() {
        if (this.server != null) {
            return Optional.of(this.server);
        }
        return Optional.empty();
    }

    public Optional<Class<ObjectSerializer>> getValueSerializer() {
        return Optional.ofNullable(this.valueSerializer);
    }

    public Optional<Class<ObjectSerializer>> getKeySerializer() {
        return Optional.ofNullable(this.keySerializer);
    }

    public Optional<Duration> getExpireAfterWrite() {
        return Optional.ofNullable(this.expireAfterWrite);
    }

    public Optional<Duration> getExpireAfterAccess() {
        return Optional.ofNullable(this.expireAfterAccess);
    }

    public Optional<String> getExpirationAfterWritePolicy() {
        return Optional.ofNullable(this.expirationAfterWritePolicy);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setExpireAfterWrite(Duration expireAfterWrite) {
        this.expireAfterWrite = expireAfterWrite;
    }

    public void setExpireAfterAccess(Duration expireAfterAccess) {
        this.expireAfterAccess = expireAfterAccess;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setExpirationAfterWritePolicy(String expirationAfterWritePolicy) {
        this.expirationAfterWritePolicy = expirationAfterWritePolicy;
    }
}

