/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce.test;

import io.lettuce.core.RedisURI;
import io.micronaut.configuration.lettuce.AbstractRedisConfiguration;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.io.socket.SocketUtils;
import io.micronaut.core.util.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.embedded.RedisServer;
import redis.embedded.RedisServerBuilder;
import redis.embedded.exceptions.RedisBuildingException;

@Requirements(value={@Requires(classes={RedisServer.class}), @Requires(beans={AbstractRedisConfiguration.class})})
@Factory
@Deprecated
public class EmbeddedRedisServer
implements BeanCreatedEventListener<AbstractRedisConfiguration>,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedRedisServer.class);
    private static final String DEFAULT_MAXMEMORY_SETTING = "maxmemory 256M";
    private static final String DEFAULT_BIND_SETTING = "bind 127.0.0.1 ::1";
    private final Configuration embeddedConfiguration;
    private RedisServer redisServer;

    public EmbeddedRedisServer(Configuration embeddedConfiguration) {
        this.embeddedConfiguration = embeddedConfiguration;
    }

    public AbstractRedisConfiguration onCreated(BeanCreatedEvent<AbstractRedisConfiguration> event) {
        AbstractRedisConfiguration configuration = (AbstractRedisConfiguration)((Object)event.getBean());
        Optional<RedisURI> uri = configuration.getUri();
        int port = configuration.getPort();
        String host = configuration.getHost();
        if (uri.isPresent()) {
            RedisURI redisURI = uri.get();
            port = redisURI.getPort();
            host = redisURI.getHost();
        }
        if (StringUtils.isNotEmpty((CharSequence)host) && host.equals("localhost") && SocketUtils.isTcpPortAvailable((int)port)) {
            RedisServerBuilder builder = this.embeddedConfiguration.builder;
            builder.port(Integer.valueOf(port));
            try {
                builder.setting(DEFAULT_MAXMEMORY_SETTING);
                builder.setting(DEFAULT_BIND_SETTING);
            }
            catch (RedisBuildingException e) {
                LOGGER.debug("Embedded settings failed as config file is present");
            }
            this.redisServer = builder.build();
            this.redisServer.start();
        }
        return configuration;
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        if (this.redisServer != null) {
            this.redisServer.stop();
        }
    }

    @ConfigurationProperties(value="redis.embedded")
    @Requires(classes={RedisServerBuilder.class})
    @Deprecated
    public static class Configuration {
        @ConfigurationBuilder(prefixes={""})
        RedisServerBuilder builder = new RedisServerBuilder().port(Integer.valueOf(SocketUtils.findAvailableTcpPort()));
    }
}

