/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.resource.ClientResources;
import io.micronaut.configuration.lettuce.AbstractRedisConfiguration;
import io.micronaut.configuration.lettuce.ClientResourcesMutator;
import io.micronaut.core.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class AbstractRedisClientFactory {
    public RedisClient redisClient(AbstractRedisConfiguration config) {
        Optional<RedisURI> uri = config.getUri();
        return uri.map(RedisClient::create).orElseGet(() -> RedisClient.create((RedisURI)config));
    }

    public RedisClient redisClient(AbstractRedisConfiguration config, @Nullable ClientResources optionalClientResources, @Nullable List<ClientResourcesMutator> mutators) {
        ClientResources clientResources = this.configureClientResources(config, optionalClientResources, mutators);
        if (clientResources == null) {
            return this.redisClient(config);
        }
        Optional<RedisURI> uri = config.getUri();
        return uri.map(redisURI -> RedisClient.create((ClientResources)clientResources, (RedisURI)redisURI)).orElseGet(() -> RedisClient.create((ClientResources)clientResources, (RedisURI)config));
    }

    @Deprecated
    public RedisClient redisClient(AbstractRedisConfiguration config, @Nullable ClientResources optionalClientResources) {
        return this.redisClient(config, optionalClientResources, Collections.emptyList());
    }

    public StatefulRedisConnection<String, String> redisConnection(RedisClient redisClient) {
        return redisClient.connect();
    }

    public StatefulRedisPubSubConnection<String, String> redisPubSubConnection(RedisClient redisClient) {
        return redisClient.connectPubSub();
    }

    @Nullable
    private ClientResources configureClientResources(AbstractRedisConfiguration config, @Nullable ClientResources clientResources, @Nullable List<ClientResourcesMutator> mutators) {
        ClientResources.Builder clientResourcesBuilder;
        ClientResources.Builder builder = clientResourcesBuilder = clientResources == null ? ClientResources.builder() : clientResources.mutate();
        if (mutators != null) {
            mutators.forEach(clientResourcesMutator -> clientResourcesMutator.mutate(clientResourcesBuilder, config));
        }
        return clientResourcesBuilder.build();
    }
}

