/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce;

import io.lettuce.core.resource.ClientResources;
import io.micronaut.configuration.lettuce.AbstractRedisConfiguration;
import io.micronaut.configuration.lettuce.ClientResourcesMutator;
import jakarta.inject.Singleton;

@Singleton
public class ThreadPoolClientResourceMutator
implements ClientResourcesMutator {
    @Override
    public void mutate(ClientResources.Builder builder, AbstractRedisConfiguration config) {
        if (config.getIoThreadPoolSize() != null) {
            builder.ioThreadPoolSize(config.getIoThreadPoolSize().intValue());
        }
        if (config.getComputationThreadPoolSize() != null) {
            builder.computationThreadPoolSize(config.getComputationThreadPoolSize().intValue());
        }
    }
}

