/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce.cache;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.support.AsyncConnectionPoolSupport;
import io.lettuce.core.support.AsyncPool;
import io.lettuce.core.support.BoundedPoolConfig;
import io.micronaut.configuration.lettuce.DefaultRedisConnectionPoolConfiguration;
import io.micronaut.configuration.lettuce.RedisConnectionUtil;
import io.micronaut.configuration.lettuce.cache.DefaultRedisCacheConfiguration;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import jakarta.inject.Singleton;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

@Factory
public final class RedisAsyncConnectionPoolFactory {
    @Singleton
    @Requires(beans={DefaultRedisCacheConfiguration.class, DefaultRedisConnectionPoolConfiguration.class})
    public AsyncPool<StatefulConnection<byte[], byte[]>> getAsyncPool(DefaultRedisCacheConfiguration defaultRedisCacheConfiguration, BeanLocator beanLocator, DefaultRedisConnectionPoolConfiguration defaultRedisConnectionPoolConfiguration) {
        Optional<String> server = defaultRedisCacheConfiguration.getServer();
        AbstractRedisClient client = RedisConnectionUtil.findClient(beanLocator, server, "No Redis server configured to allow caching");
        BoundedPoolConfig asyncConfig = defaultRedisConnectionPoolConfiguration.getBoundedPoolConfig();
        CompletionStage stage = AsyncConnectionPoolSupport.createBoundedObjectPoolAsync(() -> {
            if (client instanceof RedisClusterClient) {
                return CompletableFuture.completedFuture(((RedisClusterClient)client).connect((RedisCodec)new ByteArrayCodec()));
            }
            if (client instanceof RedisClient) {
                return CompletableFuture.completedFuture(((RedisClient)client).connect((RedisCodec)new ByteArrayCodec()));
            }
            throw new ConfigurationException("Invalid Redis connection");
        }, (BoundedPoolConfig)asyncConfig);
        return (AsyncPool)stage.toCompletableFuture().join();
    }
}

