/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce.session;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.serialize.ObjectSerializer;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.Toggleable;
import io.micronaut.session.http.HttpSessionConfiguration;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Optional;

@ConfigurationProperties(value="redis")
public class RedisHttpSessionConfiguration
extends HttpSessionConfiguration
implements Toggleable {
    private String namespace = "micronaut:session:";
    private String serverName;
    private String sessionCreatedTopic = this.namespace + "event:session-created";
    private String activeSessionsKey = this.namespace + "active-sessions";
    private Class<ObjectSerializer> valueSerializer;
    private Charset charset = StandardCharsets.UTF_8;
    private boolean enableKeyspaceEvents = true;
    private WriteMode writeMode = WriteMode.BATCH;
    private Duration expiredSessionCheck = Duration.ofMinutes(1L);

    public String getNamespace() {
        return this.namespace;
    }

    public Optional<String> getServerName() {
        return Optional.ofNullable(this.serverName);
    }

    public String getSessionCreatedTopic() {
        return this.sessionCreatedTopic;
    }

    public String getActiveSessionsKey() {
        return this.activeSessionsKey;
    }

    public Optional<Class<ObjectSerializer>> getValueSerializer() {
        return Optional.ofNullable(this.valueSerializer);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean isEnableKeyspaceEvents() {
        return this.enableKeyspaceEvents;
    }

    public WriteMode getWriteMode() {
        return this.writeMode;
    }

    public Duration getExpiredSessionCheck() {
        return this.expiredSessionCheck;
    }

    public void setNamespace(String namespace) {
        if (StringUtils.isNotEmpty((CharSequence)namespace)) {
            this.namespace = namespace;
        }
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setSessionCreatedTopic(String sessionCreatedTopic) {
        this.sessionCreatedTopic = sessionCreatedTopic;
    }

    public void setActiveSessionsKey(String activeSessionsKey) {
        this.activeSessionsKey = activeSessionsKey;
    }

    public void setValueSerializer(Class<ObjectSerializer> valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setEnableKeyspaceEvents(boolean enableKeyspaceEvents) {
        this.enableKeyspaceEvents = enableKeyspaceEvents;
    }

    public void setWriteMode(WriteMode writeMode) {
        this.writeMode = writeMode;
    }

    public void setExpiredSessionCheck(Duration expiredSessionCheck) {
        this.expiredSessionCheck = expiredSessionCheck;
    }

    static enum WriteMode {
        BATCH,
        BACKGROUND;

    }
}

